/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.filter.impl;

import java.util.List;

import com.sap.cloud.sdk.service.prov.api.filter.LiteralNode;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionOperatorTypes.NODE_KIND;

public class LiteralNodeImpl   implements LiteralNode , FilterNodeInternal{
	private NodeInfoImpl nodeInfo ;
    private Object value ;
 
	public LiteralNodeImpl(Object value,  NodeInfoImpl nodeInfo) {
		this.value = value ; 
		this.nodeInfo = nodeInfo ;
	}
 
 
	@Override
	public NODE_KIND getKind() {
		return nodeInfo.getNodeKind();
	}

	@Override
	public List<FilterNodeInternal> getChildren() {
	 		return null;
	}
	@Override
	public boolean isLeafUnit(){
		return false;
	}

	@Override
	public void setValue(Object obj) {
		this.value = obj;		
	}

	@Override
	public Object getValue() {
		return value;
	}
	
	@Override
	public boolean isCustomNode() {
	
		return nodeInfo.isCustomNode();
	}


	@Override
	public String getOperator() {
		return nodeInfo.getNodeOperator();
	}

	
}
