/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.filter.impl;

import com.sap.cloud.sdk.service.prov.api.filter.NodeInfo;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionOperatorTypes.NODE_KIND;
import com.sap.cloud.sdk.service.prov.api.filter.exception.FilterOptionException;

public class NodeInfoImpl implements NodeInfo {
	private String nodeOperator;
	private NODE_KIND nodeKind;
	private boolean customNode = false;

	public NodeInfoImpl(String nodeOperator, NODE_KIND kind) {
		this.nodeOperator = nodeOperator;
		this.nodeKind = kind;
	}

	public NodeInfoImpl(NODE_KIND kind) throws FilterOptionException {
		// Only Valid for Literal
		if (kind == NODE_KIND.LITERAL || kind == NODE_KIND.PROPERTY) {
			this.nodeOperator = "";
			this.nodeKind = kind;
		} else {
			throw new FilterOptionException(
					"Only Literal and Simple Property types are supported without Node Operator in Filter Expression Tree");

		}

	}

	@Override
	public String getNodeOperator() {
		return nodeOperator;
	}

	/**
	 * Gets the type of node in the filter expression tree. For example, Unary or Binary.
	 * 
	 * @return An enumeration representing the type of node
	 */
	public NODE_KIND getNodeKind() {
		return nodeKind;
	}

	public void setCustomNode(boolean customNode) {
		this.customNode = customNode;
	}

	public boolean isCustomNode() {	
      return customNode;
	}
}
