/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.filter.impl;

import java.util.List;

import com.sap.cloud.sdk.service.prov.api.filter.PropertyNode;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionOperatorTypes.NODE_KIND;
 

public class PropertyNodeImpl   implements PropertyNode,FilterNodeInternal {
	private String path;
	private NodeInfoImpl nodeInfo ;
	
	public PropertyNodeImpl(String path ,  NodeInfoImpl nodeInfo) {
		this.path = path;
		this.nodeInfo = nodeInfo ;
	}

	@Override
	public String getPath() {
		return path;
	}
	@Override
	public NODE_KIND getKind() {
		return NODE_KIND.PROPERTY ;
	}
	@Override
	public List<FilterNodeInternal> getChildren() {
		 return null;
	}
	@Override
	public boolean isLeafUnit(){
		return false;
	}

	@Override
	public void setPath(String path) {		
		this.path = path;
	}
	
	@Override
	public boolean isCustomNode() {
		return nodeInfo.isCustomNode();
	}

	@Override
	public String getOperator() {
		return nodeInfo.getNodeOperator();
	}

}
