/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.filter.impl;

import java.util.Arrays;
import java.util.List;

import com.sap.cloud.sdk.service.prov.api.filter.ExpressionNode;
import com.sap.cloud.sdk.service.prov.api.filter.UnaryExpressionNode;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionOperatorTypes.NODE_KIND;

public class UnaryExpressionNodeImpl implements UnaryExpressionNode, FilterNodeInternal {
	private FilterNodeInternal child;
	private NodeInfoImpl nodeInfo;
	private boolean leafUnitNode = false;

	public UnaryExpressionNodeImpl(FilterNodeInternal child, NodeInfoImpl nodeInfo) {
		this.child = child;
		this.nodeInfo = nodeInfo;
		leafUnitNode = getChildren().stream().filter(node -> {
			return ((node.getKind() == NODE_KIND.PROPERTY || node.getKind() == NODE_KIND.LITERAL) ? true : false);
		}).findAny().isPresent();
	}

	@Override
	public ExpressionNode getChild() {
		return child;
	}

	@Override
	public NODE_KIND getKind() {
		return NODE_KIND.UNARY;
	}

	@Override
	public List<FilterNodeInternal> getChildren() {
		return Arrays.asList(child);
	}

	@Override
	public String getOperator() {
		return nodeInfo.getNodeOperator();
	}

	@Override
	public boolean isLeafUnit() {
		return leafUnitNode;
	}

	@Override
	public boolean isCustomNode() {
		return nodeInfo.isCustomNode();
	}

	 

}
