/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.internal;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

import com.sap.cloud.sdk.service.prov.api.annotations.Action;
import com.sap.cloud.sdk.service.prov.api.annotations.AfterCreate;
import com.sap.cloud.sdk.service.prov.api.annotations.AfterDelete;
import com.sap.cloud.sdk.service.prov.api.annotations.AfterOperation;
import com.sap.cloud.sdk.service.prov.api.annotations.AfterQuery;
import com.sap.cloud.sdk.service.prov.api.annotations.AfterRead;
import com.sap.cloud.sdk.service.prov.api.annotations.AfterUpdate;
import com.sap.cloud.sdk.service.prov.api.annotations.BeforeAll;
import com.sap.cloud.sdk.service.prov.api.annotations.BeforeCreate;
import com.sap.cloud.sdk.service.prov.api.annotations.BeforeDelete;
import com.sap.cloud.sdk.service.prov.api.annotations.BeforeOperation;
import com.sap.cloud.sdk.service.prov.api.annotations.BeforeQuery;
import com.sap.cloud.sdk.service.prov.api.annotations.BeforeRead;
import com.sap.cloud.sdk.service.prov.api.annotations.BeforeUpdate;
import com.sap.cloud.sdk.service.prov.api.annotations.CleanupTransaction;
import com.sap.cloud.sdk.service.prov.api.annotations.EndTransaction;
import com.sap.cloud.sdk.service.prov.api.annotations.ExtendAction;
import com.sap.cloud.sdk.service.prov.api.annotations.ExtendCreate;
import com.sap.cloud.sdk.service.prov.api.annotations.ExtendDelete;
import com.sap.cloud.sdk.service.prov.api.annotations.ExtendFunction;
import com.sap.cloud.sdk.service.prov.api.annotations.ExtendRead;
import com.sap.cloud.sdk.service.prov.api.annotations.ExtendReadStream;
import com.sap.cloud.sdk.service.prov.api.annotations.ExtendUpdate;
import com.sap.cloud.sdk.service.prov.api.annotations.Function;
import com.sap.cloud.sdk.service.prov.api.annotations.InitTransaction;
import com.sap.cloud.sdk.service.prov.api.operations.ChangeSet;
import com.sap.cloud.sdk.service.prov.api.operations.Create;
import com.sap.cloud.sdk.service.prov.api.operations.Delete;
import com.sap.cloud.sdk.service.prov.api.operations.Query;
import com.sap.cloud.sdk.service.prov.api.operations.Read;
import com.sap.cloud.sdk.service.prov.api.operations.Update;

public class CustomHandlerAnnotations {
	static List<Class> customHandlerAnnotations = Arrays.asList(ExtendCreate.class, ExtendUpdate.class, ExtendDelete.class,
			ExtendRead.class, Query.class, Create.class, Update.class, Delete.class, Read.class, BeforeCreate.class,
			BeforeUpdate.class, BeforeDelete.class, BeforeQuery.class, BeforeRead.class, AfterCreate.class,
			AfterUpdate.class, AfterDelete.class, AfterQuery.class, AfterRead.class, InitTransaction.class,
			EndTransaction.class, CleanupTransaction.class, ExtendFunction.class, ExtendAction.class, Function.class,
			Action.class, BeforeOperation.class, AfterOperation.class, ExtendReadStream.class, BeforeAll.class, ChangeSet.class);
	
	/**
	 * Returns true if the method is a custom handler in an autoexposure or CXS scenario.
	 * @param method
	 * @return a boolean value indicating whether the method is a custom handler
	 */
	
	private static boolean isCustomHandler(Method method) {
		for(Class annotationClass : customHandlerAnnotations) {
			if(method.isAnnotationPresent(annotationClass))
				return true;
		}
		
		return false;
	}
	
	public static boolean isExtensionClass(Class c) {
		try {
			Method[] methods = c.getMethods();
			return Arrays.stream(methods).filter(m->isCustomHandler(m)).findFirst().isPresent();
			/*
			 * We catch Throwable which is not recommended in general usage,
			 * We do so because, occasionally some unchecked exceptions come when classes from entire
			 * classpath are being loaded. In our scenario we just need to discard such classes,
			 * Hence we catch throwable. Apart from the fatal error VirtualMachineError, we 
			 * discard all other throwables(by returning false). For VirtualMachineErrors(subclasses of which
			 * are OutOfMemoryError, StackOverflowError, InternalError and UnknownError) we directly throw
			 * it because this is too serious to ignore.
			 */
		} catch (Throwable t) { //NOSONAR
			if(t instanceof VirtualMachineError) {
				throw (VirtualMachineError)t;
			}
			return false;
		}
	}
}
