/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonAutoDetect.Visibility;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.sap.cloud.sdk.service.prov.api.EntityData;
import com.sap.cloud.sdk.service.prov.api.EntityMetadata;
import com.sap.cloud.sdk.service.prov.api.exception.DataConversionException;

public class DefaultEntityData extends EntityData implements HasMetadata {

	Map<String,Object> properties;
	EntityMetadata em;
	Map<String,Object> associationProperties = new HashMap<>();
	public DefaultEntityData(Map<String, Object> propertyMap, EntityMetadata entityMetadata) {
		properties = propertyMap;
		em = entityMetadata;
	}
	
	public DefaultEntityData(Map<String, Object> propertyMap, Map<String, Object> associationPropertiesMap, EntityMetadata entityMetadata) {
		properties = propertyMap;
		em = entityMetadata;
		associationProperties = associationPropertiesMap;
	}
	
	@Override
	protected Object getPropertyValue(String name) {
		return properties.get(name);
	}
	
	@Override
	public boolean contains(String name) {
		return properties.containsKey(name);
	}
	
	@Override
	public EntityMetadata getEntityMetadata() {
		return em;
	}
	
	@Override
	public Map<String, Object> getMap() {
		return properties;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public Map<String, Object> asMap() {
		return (Map<String, Object>) cloneDeepMap((Map<String, Object>) properties, associationProperties);
	}
	

	private static Object cloneDeepMap(Map<String, Object> properties, Map<String,Object> associationProperties) {
		HashMap<String, Object> cloned = (HashMap<String, Object>)cloneMap(properties);
		if(associationProperties == null || associationProperties.isEmpty()){
			return cloned;
		}
		for(Map.Entry<String, Object> entry : associationProperties.entrySet()) {
			Object obj = associationProperties.get(entry.getKey());
			if(obj instanceof ArrayList){
				ArrayList cnvList = new ArrayList();
				ArrayList list = (ArrayList) obj;
				if(list.isEmpty()) {
					cloned.put(entry.getKey(), cnvList);
				}
				for(int i=0; i<list.size(); i++){
					Object item = list.get(i);
					if(item instanceof EntityData){
						EntityData entityData = (EntityData) item;
						cnvList.add(cloneDeepMap(entityData.getMap(), entityData.getAssociations()));
						cloned.put(entry.getKey(), cnvList);
					}else {
						cnvList.add(cloneProperty(item));
						cloned.put(entry.getKey(), cnvList);
					}
				}
			}else if(obj instanceof EntityData){
				EntityData entityData = (EntityData) obj;				
				cloned.put(entry.getKey(), cloneDeepMap(entityData.getMap(), entityData.getAssociations()));
			}else{
				cloned.put(entry.getKey(), cloneProperty(obj));
			}
		}
		return cloned;
	}
	
	// This method exposes entityData as POJO
	public <T> T as(Class<T> t) throws DataConversionException {
		Map<String, Object> copy = this.asMap();

			ObjectMapper mapper = new ObjectMapper();
			/*-- Ignore Null Values --*/
			mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
			/*-- do not fail on empty beans  --*/
			mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
			/*-- First: hide all elements in the class ; make property,getter,setter hidden  --*/
			mapper.setVisibility(PropertyAccessor.ALL, Visibility.NONE);
			/*-- Second: now only make the properties discoverable   --*/
			mapper.setVisibility(PropertyAccessor.FIELD, Visibility.ANY);
			mapper.setSerializationInclusion(Include.NON_NULL);
			mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
			T pojo;
			try {
				pojo = (T) mapper.convertValue(copy, Class.forName(t.getTypeName()));
			} catch (IllegalArgumentException | ClassNotFoundException e) {
				throw new DataConversionException( e.getMessage(), e.getCause());
			}
			return pojo;
			

		}

	@Override
	public Object getAssociationValue(String name) {
		
		if(associationProperties != null){
			return associationProperties.get(name);
		}
		return null;
	}

	@Override
	public Map<String,Object> getAssociations() {
		return associationProperties;
	}

}
