/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.internal;

import java.util.HashMap;
import java.util.List;

import com.sap.cloud.sdk.service.prov.api.ElementType;
import com.sap.cloud.sdk.service.prov.api.EntityMetadata;
import com.sap.cloud.sdk.service.prov.api.StructuredTypeMetadata;

public class DefaultEntityMetadata implements EntityMetadata {

	String entityName;
	HashMap<String, ElementType> elementTypes;
	List<String> elementNames;
	List<String> flattenedElementNames;
	List<String> keys;
	String ns;
	StructuredTypeMetadata structuredTypeMetadata;

	public DefaultEntityMetadata() {

	}

	@Override
	public String getName() {
		return entityName;
	}

	@Override
	public List<String> getElementNames() {
		return elementNames;
	}

	@Override
	public List<String> getKeyNames() {
		return keys;
	}

	@Override
	public String getNamespace() {
		return ns;
	}
	
	public HashMap<String, ElementType> getElementTypes() {
		return elementTypes;
	}
	
	public DefaultEntityMetadata setEntityName(String name) {
		entityName = name;
		return this;
	}
	
	public DefaultEntityMetadata setKeys(List<String> keys) {
		this.keys = keys;
		return this;
	}
	
	public DefaultEntityMetadata setElements(List<String> elements) {
		elementNames = elements;
		return this;
	}
	
	public DefaultEntityMetadata setNamespace(String namespace) {
		ns = namespace;
		return this;
	}


	@Override
	public ElementType getElementType(String elementName) {
		return elementTypes.containsKey(elementName) ? elementTypes.get(elementName) : ElementType.SIMPLE_TYPE;
	}

	@Override
	public StructuredTypeMetadata getStructuredTypeMetadata(String structuredTypeName) {
		// This is not populated since for now Metadata from HashMap is sufficient for the current operations.
		return null;
	}

	@Override
	public List<String> getFlattenedElementNames() {
		return flattenedElementNames;
	}

	public DefaultEntityMetadata setElementTypes(HashMap<String, ElementType> elementTypes) {
		this.elementTypes = elementTypes;
		return this;
	}

	public DefaultEntityMetadata setFlattenedElements(List<String> flattenedElements) {
		flattenedElementNames = flattenedElements;
		return this;
	}

	@Override
	public EntityMetadata getAssociationMetaData(String associationName) {
		// As of now, this class doesn't need implementation of this method
		return null;
	}
	
	@Override
	public List<String> getAssociationNames() {
		return null;
	}
}
