/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.internal;

/**
 * Provides utility methods for constructing proper SQL based on the current SQL mapping mode.
 * Currently the mapping mode is determined from the csn. This class methods are 
 * mainly used in CDS query formation classes where they are added as static imports.
 */
public class SQLMapping {

	private static Boolean plainSqlMapping = null;
	
	public static String quoteIfRequired(String sqlPart) {
		initialize();
		if(plainSqlMapping)
			return sqlPart;
		return '"' + sqlPart + '"';
	}

	private static void initialize() {
		if(plainSqlMapping == null)
			plainSqlMapping = CSNUtil.isPlainSqlMapping();
	}
	
	public static String convertToUpperCaseIfRequired(String sqlPart) {
		initialize();
		if(plainSqlMapping)
			return sqlPart.toUpperCase();
		return sqlPart;
	}
	
	public static String getSeparator() {
		initialize();
		if(plainSqlMapping)
			return "_";
		return ".";
	}
	
	public static boolean isPlainSqlMapping() {
		initialize();
		return plainSqlMapping;
	}
	
	public static String replaceDotIfRequired(String name) {
		if(name == null)
			return null;
		else
			return name.replaceAll("\\.", getSeparator());
	}
	
}
