/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.locale.impl;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class LocaleTypeResolver{
	
	private static Boolean isAllLocalSupported = false;
	private static Set<String> whiteListedLocale = new HashSet<String>();
	private static final String DELIMITER_1 = "-";
	private static final String DELIMITER_2 = "_";
	
	
	public static void addSupportForLocale(Set<String> supportedLocales){
		if(supportedLocales!=null)
			whiteListedLocale.addAll(supportedLocales);
	}
	
	public static void addsupportForAllLocale(Boolean isAllLocaleSupported){
		isAllLocalSupported = isAllLocaleSupported;
	}
	
	public static Set<String> getAllWhiteListedLocale(){
		return whiteListedLocale;
	}
	
	public static Boolean isAllLocaleSupported(){
		return isAllLocalSupported;
	}

	public static String getLanguage(String locale) {
		if(isAllLocalSupported)
			return locale;
		if(getAllWhiteListedLocale().contains(locale))
			return locale;
		else
		{
			if(locale.length()>=2)
				return locale.substring(0, 2);
			else
				return locale;
		}
	}
	
	public static Locale getLocale(String acceptLanguage){
		Locale locale = null;
		if(acceptLanguage == null || "".equals(acceptLanguage.trim()) || "*".equals(acceptLanguage.trim())){
			//Default to en-US			
			locale = new Locale("en", "US");
		}else{
			int tokenCount = 0;
			String language = "";
			String country = "";
			String variant = "";
			
			if(acceptLanguage.indexOf(DELIMITER_1) != -1){
				language = acceptLanguage.substring(0, acceptLanguage.indexOf(DELIMITER_1));
				acceptLanguage = acceptLanguage.substring(acceptLanguage.indexOf(DELIMITER_1)+1);
				tokenCount++;
				if(acceptLanguage.indexOf(DELIMITER_1) != -1){
					country = acceptLanguage.substring(0, acceptLanguage.indexOf(DELIMITER_1));
					tokenCount++;					
					acceptLanguage = acceptLanguage.substring(acceptLanguage.indexOf(DELIMITER_1)+1);
					if(acceptLanguage != null && !"".equals(acceptLanguage.trim())){
						variant = acceptLanguage;
						tokenCount++;						
					}
				}else{
					country = acceptLanguage.substring(0);
					tokenCount++;					
				}
			}
			else if(acceptLanguage.indexOf(DELIMITER_2) != -1){
				language = acceptLanguage.substring(0, acceptLanguage.indexOf(DELIMITER_2));
				acceptLanguage = acceptLanguage.substring(acceptLanguage.indexOf(DELIMITER_2)+1);
				tokenCount++;
				if(acceptLanguage.indexOf(DELIMITER_2) != -1){
					country = acceptLanguage.substring(0, acceptLanguage.indexOf(DELIMITER_2));
					tokenCount++;					
					acceptLanguage = acceptLanguage.substring(acceptLanguage.indexOf(DELIMITER_2)+1);
					if(acceptLanguage != null && !"".equals(acceptLanguage.trim())){
						variant = acceptLanguage;
						tokenCount++;						
					}
				}else{
					country = acceptLanguage.substring(0);
					tokenCount++;					
				}
			}
			else{
				language = acceptLanguage;
				tokenCount++;
			}
			
			if(tokenCount == 3){
				locale = new Locale(language, country, variant);
			}else if(tokenCount == 2){
				locale = new Locale(language, country);				
			}else if(tokenCount == 1){
				locale = new Locale(language);				
			}
		}
		return locale;
	}
}
