/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.operations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
* <p>The <code>ChangeSet</code> annotation attached to a public method specifies
* that the method implements the ChangeSet in a Batch request.</p>
*
* <p> A method to which this annotation is attached must provide the following: 
* 	<ol>
* 		<li>
* 			Input parameter of type {@link com.sap.cloud.sdk.service.prov.api.ChangeSetHandler ChangeSetHandler}
* 		</li>
* 	</ol>
* <p>
* The following sample code shows how you can apply this annotation to a method:
* <pre>
* <b>&#064;ChangeSet</b> (<b>serviceName = "EPMSampleService"</b>)
* public void processChangeSet(ChangeSetHandler changeSetHandler) {
* 	try {
*		//Add your initialization logic to save the current state of data
*		//...
*
*		//Iterate over the data modification operations in the ChangeSet
*		while (changeSetHandler.hasNextRequest()) {
*			//Retrieve the request, process it and add the response for each operation
*			Request request = changeSetHandler.nextRequest();
*			Response response = changeSetHandler.handleRequest(request);
*			changeSetHandler.addResponse(response);
*		}
*		//Add your logic to commit the changes
*		//...
*   } catch (Exception e) {
*   	//Add your logic to rollback the changes
*		//...
*   }
* }
* </pre>
*  By applying the ChangeSet annotation, the processChangeSet method gets invoked whenever there is a  
*  batch request with ChangeSet on EPMSampleService.
*/ 
// @param serviceName (optional) A <code>String</code> containing the name of the service



@Target({ ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
public @interface ChangeSet {

	String serviceName() default "";

}
