/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.operations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
* <p>The <code>Query</code> annotation attached to a public method specifies
* that the method implements the query operation of an entity in a service.</p>
*
* <p> A method to which this annotation is attached must provide the following: 
* 	<ol>
* 		<li>
* 			Input parameter of type {@link com.sap.cloud.sdk.service.prov.api.request.QueryRequest QueryRequest}
* 		</li>
* 		<li>
* 			Return value of type {@link com.sap.cloud.sdk.service.prov.api.response.QueryResponse QueryResponse}
* 		</li>
* 	</ol>
* <p>
*
* @param serviceName A <code>String</code> containing the name of the service
* @param entity A <code>String</code> containing the name of the entity within the service
* @param sourceEntity (optional) A <code>String</code> containing the name of the parent entity
*/

@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface Query {
  
  String serviceName();
  
  String entity();
  
  String sourceEntity()default "";
  
}
