/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.operations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
* <p>The <code>Update</code> annotation attached to a public method specifies
* that the method implements the Update operation of an entity in a service.</p>
*
* <p>
*  A method to which this annotation is attached supports two signatures depending on the following scenarios:
* </p>
* <p> 
* SCENARIO 1: You're executing the Update operation on your local HANA database.
* 	<ol>
* 		<li>
* 			Input parameter of type {@link com.sap.cloud.sdk.service.prov.api.request.UpdateRequest UpdateRequest}
* 		</li>
*   	<li>
* 			Input parameter of type {@link com.sap.cloud.sdk.service.prov.api.ExtensionHelper ExtensionHelper} 
* 		</li>
* 		<li>
* 			Return value of type {@link com.sap.cloud.sdk.service.prov.api.response.UpdateResponse UpdateResponse}
* 		</li>
* 	</ol>
*  </p>
*  
* <p> 
* SCENARIO 2: You're executing the Update operation only on a remote data source. 
* 	<ol>
* 		<li>
* 			Input parameter of type {@link com.sap.cloud.sdk.service.prov.api.request.UpdateRequest UpdateRequest}
* 		</li>
* 		<li>
* 			Return value of type {@link com.sap.cloud.sdk.service.prov.api.response.UpdateResponse UpdateResponse}
* 		</li>
* 	</ol>
*  </p>
* <p>
* @param serviceName A <code>String</code> containing the name of the service
* @param entity A <code>String</code> containing the name of the entity within the service
*/

@Target({ ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
public @interface Update {
	
	String serviceName();
	
	String entity();
}
