/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.request;

import java.util.Map;

import com.sap.cloud.sdk.service.prov.api.EntityData;
import com.sap.cloud.sdk.service.prov.api.exception.DataConversionException;

/**
 * Provides the request information for creating an entity in a service.
 */
public abstract class CreateRequest extends Request {
	/**
	 * Gets an EntityData object corresponding to the entity to be created.
	 * @return An <code>EntityData</code> object that represents the entity
	 */
	public abstract EntityData getData();
	
	/**
	 * Gets key-value pairs representing the properties of the entity to be created.
	 * @return A {@link java.util.Map Map} containing key-value pairs
	 */	
	public abstract Map<String, Object> getMapData();

	/**
	 * Gets the keys of the parent entity specified in a navigation.
	 * For example, if the URL is /EPMSampleService/SalesOrders(1)/ToSalesOrderLineItems,
	 * then this method returns (SalesOrderID,1).
	 * @return A {@link java.util.Map Map} containing the keys of the parent entity
	 */
	public abstract Map<String,Object>  getSourceKeys();	
	
	/**
	 * Gets the POJO representation of the entity to be created.
	 * @return A POJO containing data in the respective fields
	 * @exception An exception of type {@link  com.sap.cloud.sdk.service.prov.api.exception.ConversionException}
	 * may be thrown in case of error situation
	 */
	public abstract <T> T getDataAs (Class<T>  t)throws DataConversionException ;  
	
}
