/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.request;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import com.sap.cloud.sdk.service.prov.api.Message;
import com.sap.cloud.sdk.service.prov.api.MessageContainer;
import com.sap.cloud.sdk.service.prov.api.Severity;

public class MessageContainerImpl implements MessageContainer {

	private Message leading;
	private List<Message> messageDetails = new ArrayList<>();
	private static final String PROPERTY_FILE_NAME = "i18n.i18n";
	private static final ThreadLocal<Locale> localeThreadPool = new ThreadLocal<>();

	public MessageContainerImpl(Locale locale) {
		MessageContainerImpl.localeThreadPool.set(locale);
	}

	@Override
	public void addInfoMessage(String code, String target, Object... params) {
		messageDetails.add(new Message(code, getLocalizedMessage(code,params), target, Severity.INFO));
	}

	@Override
	public void addWarningMessage(String code, String target, Object... params) {
		messageDetails.add(new Message(code, getLocalizedMessage(code,params), target, Severity.WARNING));
	}

	@Override
	public void addErrorMessage(String code, String target, Object... params) {
		messageDetails.add(new Message(code, getLocalizedMessage(code,params), target, Severity.ERROR));
	}

	@Override
	public void setLeadingMessage(String code, String target, Object... params) {
		leading = new Message(code, getLocalizedMessage(code,params), target, Severity.SUCCESS);
	}

	public List<Message> getMessageDetails() {
		return messageDetails;
	}

	public Message getLeadingMessage() {
		return leading;
	}

	@Override
	public void addSuccessMessage(String code, String target, Object... params) {
		messageDetails.add(new Message(code, getLocalizedMessage(code,params), target, Severity.SUCCESS));
	}

	public static String getLocalizedMessage(String code, Object... params) {
		try {
			Locale locale = MessageContainerImpl.localeThreadPool.get();
			ResourceBundle resBundle = ResourceBundle.getBundle(PROPERTY_FILE_NAME, locale == null ? Locale.ENGLISH : locale);
			String message = resBundle.getString(code);
			return MessageFormat.format(message, params);
		} catch (MissingResourceException mre) {
			return code;
		}
	}

}
