/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.request;

import java.util.Map;

/**
 * Provides the request information of an operation in a service.
 */
public abstract class OperationRequest extends GenericRequest {

	protected String operationName;

	
	
	/**
	 * Gets the name of the operation import specified in the GET operation.
	 * @return A <code>String</code> containing the name of the function import
	 */
	public String getOperationName() {
		return operationName;
	}
	
	/**
	 * Gets the parameters for the function call. 	 
	 * For example, if the URL is /SampleService2/approveLeave?EmployeeID=1, then the key retrieved from the URL is (EmployeeID,1).
	 * @return A {@link java.util.Map Map} object containing key-value pairs of the parameters in the URL
	 */	
	public abstract Map<String,Object> getParameters();
	
	
}
