/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.request;

public abstract class OrderByExpression {
	
	/**
	 * Indicates whether the sorting order specified in the $orderby system query option is descending.
	 * For example, if the URL is Northwind.svc/Categories?$orderby=CarrierName desc,
	 * then the value returned by this method is true.
	 * @return <code>boolean</code> indicating whether the sorting order is descending
	 */
     public	abstract  boolean isDescending();
	   
     /**
 	 * Gets the property specified in the $orderby system query option.
 	 * For example, if the URL is Northwind.svc/Categories?$orderby=CarrierName desc,
 	 * then the property of the entity set returned by this method is CarrierName.
 	 * @return A <code>String</code> containing the property name
 	 */
	 public abstract String getOrderByProperty();
	
}
