/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.request;

import java.util.List;
import java.util.Map;

/**
 * Provides the request information for reading an entity in a service.
 */
public abstract class ReadRequest extends Request {
	/**
	 * Gets the keys of the entity to be read.
	 * For example, if the URL is /EPMSampleService/Products(1),
	 * then this method returns (ProductID,1). 
	 * Let's look at another example of a URL where a child entity is specified in a navigation: /EPMSampleService/SalesOrders(1)/ToSalesOrderLineItems(1).
	 * In this case, this method returns (SalesOrderLineItemID, 1).
	 * @return A {@link java.util.Map Map} containing the keys of the entity
	 */
	public abstract Map<String,Object> getKeys();
	
	/**
	 * Gets the keys of the parent entity specified in a navigation.
	 * For example, if the URL is /EPMSampleService/SalesOrders(1)/ToSalesOrderLineItems(1),
	 * then this method returns (SalesOrderID,1).
	 * @return A {@link java.util.Map Map} containing the keys of the parent entity
	 */
	public abstract Map<String,Object> getSourceKeys();
	/**
	 * Gets the list of properties specified in the $select system query option.
	 * For example, if the URL is /EPMSampleService/Product(1)?$select=Category,
	 * then the property of the entity set returned by this method is Category.
	 * Please note that if the system query option used in the URL is $select=*,
	 * then this method returns an empty list.
	 * @return A <code>List</code> of <code>String</code> objects containing the properties
	 * specified in $select expression
	 */
	public abstract List<String> getSelectProperties();
	
	/**
	 * Adds properties to the $select system query option.
	 * 
	 * @param selectProp A list of strings representing the properties to be added
	 */
	public abstract void addSelectProperties(List<String> selectProp);
	/**
	 * Gets the list of properties specified in the $expand system query option.
	 * For example, if the URL is /EPMSampleService/Product(1)?$expand=Category,
	 * then the property of the entity set returned by this method is Category.	 
	 * @return A <code>List</code> of <code>String</code> objects containing the properties
	 * specified in $expand expression
	 */
	public abstract List<String> getExpandProperties();
}
