/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.request;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Provides the request information for an operation.
 */
public abstract class Request extends GenericRequest {	
	final static Logger log = LoggerFactory.getLogger(Request.class);
	protected String entityName;
	protected String sourceEntityName;

	
	
	/**
	 * Returns the name of the entity on which the operation must be performed. 	 
	 * @return A <code>String</code> containing the name of the entity
	 */
	public String getEntityName() {
		return entityName;
	}

	/**
	 * Gets the name of the parent entity specified in a navigation.
	 * For example, if the URL is /EPMSampleService/SalesOrders(1)/ToSalesOrderLineItems,
	 * then the entity name returned by this method is SalesOrders.
	 * If there is no navigation defined then this method returns null.
	 * @return A <code>String</code> containing the name of the parent entity
	 */
	public String getSourceEntityName() {
		return sourceEntityName;
	}
	
	


}
