/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.request;

import java.util.Map;

import com.sap.cloud.sdk.service.prov.api.EntityData;
import com.sap.cloud.sdk.service.prov.api.exception.DataConversionException;

/**
 * Provides the request information for updating an entity in a service.
 */
public abstract class UpdateRequest extends Request {
	/**
	 * Gets an EntityData object corresponding to the entity to be updated.
	 * @return An <code>EntityData</code> object that represents the entity
	 */
	public abstract EntityData getData();
	
	/**
	 * Gets key-value pairs representing the properties of the entity to be updated.
	 * @return A {@link java.util.Map Map} containing key-value pairs
	 */	
	public abstract Map<String, Object> getMapData();	

	/**
	 * Gets the keys of the entity to be updated.
	 * For example, if the URL is /EPMSampleService/Products(1),
	 * then this method returns (ProductID,1).
	 * @return A {@link java.util.Map Map} containing the keys of the entity
	 */
	public abstract Map<String, Object> getKeys();
	
	/**
	 * Gets the POJO representation of the entity to be created.
	 * @return A POJO containing data in the respective fields
	 * @exception An exception of type {@link  com.sap.cloud.sdk.service.prov.api.exception.ConversionException}
	 * may be thrown in case of error situation
	 */
	public abstract <T> T getDataAs (Class<T>  t)throws   DataConversionException ; 
	
}
