/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.request.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.sap.cloud.sdk.service.prov.api.EntityData;
import com.sap.cloud.sdk.service.prov.api.EntityMetadata;
import com.sap.cloud.sdk.service.prov.api.exception.DataConversionException;
import com.sap.cloud.sdk.service.prov.api.request.CreateRequest;
import com.sap.cloud.sdk.service.prov.api.request.RequestContext;
import com.sap.cloud.sdk.service.prov.api.util.DataConversionUtility;


public class CreateRequestImpl extends CreateRequest {
	private Map<String, Object> sourcekeys;
	
	/* Just one object for storing data regardless of the format. Based on getter method invoked, this would be converted to 
	appropriate format using the DataConversionUtility. */
	private Object data; 

	public CreateRequestImpl(RequestContext requestContext, String entityName, EntityMetadata entityMetadata,
			Map<String, List<String>> headers, String httpMethod) {
		this.requestContext = requestContext;
		this.entityName = entityName;
		this.entityMetadata = entityMetadata;
		this.httpMethod = httpMethod;
		this.sourcekeys = new HashMap<String, Object>();
		initialiseHeaders(headers);
	}

	@Override
	public EntityData getData() {
		return DataConversionUtility.convertToEntityData(data, entityName, entityMetadata.getKeyNames());
	}

	public void setData(Object data) {
		/*
		 * The below condition is to check whether the data is of a format other
		 * than entityData, and if so convert it to entityData. We do so because
		 * we want an immutable object as the source object(unlike a pojo or a
		 * map).
		 */
		this.data = DataConversionUtility.convertToEntityData(data, entityName, entityMetadata.getKeyNames());
	}

	@Override
	public Map<String, Object> getSourceKeys() {
		return sourcekeys;
	}

	public void setSourceKeys(Map<String, Object> sourcekeys) {
		this.sourcekeys = sourcekeys;
	}

	public void setSourceEntity(String sourceEntityName) {
		this.sourceEntityName = sourceEntityName;
	}

	@Override
	public Map<String, Object> getMapData() {
		return DataConversionUtility.convertToMap(data);
	}

	@Override
	public <T> T getDataAs(Class<T> clazz) throws DataConversionException  {
		return DataConversionUtility.convertToClass(clazz, data);
	}

}
