/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.request.impl;

import java.util.List;
import java.util.Map;

import com.sap.cloud.sdk.service.prov.api.EntityMetadata;
import com.sap.cloud.sdk.service.prov.api.request.OperationRequest;
import com.sap.cloud.sdk.service.prov.api.request.RequestContext;

public class OperationRequestImpl extends OperationRequest{
	private Map<String, Object> parameters;

	
	public OperationRequestImpl(RequestContext requestContext,String operationName, Map<String,List<String>> headers, Map<String,Object> parameters, String httpMethod) {
		this.requestContext = requestContext;
		this.operationName =operationName;
		this.httpMethod = httpMethod;
		this.parameters = parameters;
		initialiseHeaders(headers);
	}
	
	public OperationRequestImpl(RequestContext requestContext,String operationName, EntityMetadata entityMetadata, Map<String,List<String>> headers, Map<String,Object> parameters, String httpMethod) {
		this.requestContext = requestContext;
		this.operationName =operationName;
		this.httpMethod = httpMethod;
		this.entityMetadata = entityMetadata;
		this.parameters = parameters;
		initialiseHeaders(headers);
	}

	@Override
	public Map<String, Object> getParameters() {
		return parameters;
	}
	

} 
