/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.request.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.sap.cloud.sdk.service.prov.api.EntityMetadata;
import com.sap.cloud.sdk.service.prov.api.filter.Expression;
import com.sap.cloud.sdk.service.prov.api.filter.ExpressionBuilder;
import com.sap.cloud.sdk.service.prov.api.request.OrderByExpression;
import com.sap.cloud.sdk.service.prov.api.request.QueryRequest;
import com.sap.cloud.sdk.service.prov.api.request.RequestContext;

public class QueryRequestImpl extends QueryRequest {

	private Map<String, Object> sourceKeys;
	private int topValue = -1;
	private int skipValue = -1;
	private List<OrderByExpression> orderByOption = new ArrayList<OrderByExpression>();
	private List<String> selectOption = new ArrayList<String>();
	private List<String> expandOption = new ArrayList<String>();
	private Map<String, String> customQueryOptions;
	private boolean countCall;
	private Expression filterTree = null;
	private boolean isInlineCount = false;

	public QueryRequestImpl(RequestContext requestContext, String entityName, EntityMetadata entityMetadata,
			Map<String, List<String>> headers, String httpMethod) {
		this.requestContext = requestContext;
		this.entityName = entityName;
		this.httpMethod = httpMethod;
		this.entityMetadata = entityMetadata;
		initialiseHeaders(headers);
	}

	@Override
	public Map<String, Object> getSourceKeys() {
		return sourceKeys;
	}

	public void setSourceEntityName(String sourceEntityName) {
		this.sourceEntityName = sourceEntityName;
	}

	public void setSourceKeys(Map<String, Object> sourceKeys) {
		this.sourceKeys = sourceKeys;
	}

	public void setTopOption(int topValue) {
		this.topValue = topValue;
	}

	@Override
	public int getTopOptionValue() {
		return topValue;
	}

	@Override
	public int getSkipOptionValue() {
		return skipValue;
	}

	public void setSkipOption(int skipValue) {
		this.skipValue = skipValue;
	}

	public void setOrderByOption(final OrderByExpression orderByOptions) {
		orderByOption.add(orderByOptions);
	}

	@Override
	public List<OrderByExpression> getOrderByProperties() {
		return orderByOption;
	}

	public void setSelectItems(final String selectItems) {
		selectOption.add(selectItems);
	}

	@Override
	public List<String> getSelectProperties() {
		Set<String> hs = new HashSet<>();
		hs.addAll(selectOption);
		selectOption.clear();
		selectOption.addAll(hs);
		return selectOption;
	}

	public void setCustomQueryOptions(Map<String, String> customQueryOptions) {
		this.customQueryOptions = customQueryOptions;

	}

	@Override
	public Map<String, String> getCustomQueryOptions() {
		return customQueryOptions;
	}

	public void setCountCall(boolean countCall) {
		this.countCall = countCall;
	}

	@Override
	public boolean isCountCall() {
		return countCall;
	}

	@Override
	public Expression getQueryExpression() {
		return this.filterTree;
	}

	public Object getQueryExpressionInternal() {
		return this.filterTree;

	}

	@Override
	public ExpressionBuilder getExpressionBuilder() {
		return new com.sap.cloud.sdk.service.prov.api.filter.impl.ExpressionBuilderImpl();
	}

	public void setQueryExpression(Expression expression) {
		this.filterTree = expression;
	}

	@Override
	public void addSelectProperties(List<String> selectedProperties) {
		for (String selectedProperty : selectedProperties) {
			selectOption.add(selectedProperty);
		}
	}

	public void setIsInlineCount(boolean isInlineCount) {
		this.isInlineCount = isInlineCount;
	}

	@Override
	public boolean isInlineCountCall() {
		return this.isInlineCount;
	}
	
	public void setExpandItems(final String expandItems) {
		expandOption.add(expandItems);
	}

	@Override
	public List<String> getExpandProperties() {
		Set<String> hs = new HashSet<>();
		hs.addAll(expandOption);
		expandOption.clear();
		expandOption.addAll(hs);
		return expandOption;
	}

}
