/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.request.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.sap.cloud.sdk.service.prov.api.EntityMetadata;
import com.sap.cloud.sdk.service.prov.api.request.ReadRequest;
import com.sap.cloud.sdk.service.prov.api.request.RequestContext;

public class ReadRequestImpl extends ReadRequest{
	private Map<String, Object> keys;
	private Map<String, Object> sourceKeys ;
	private List<String> selectOption = new ArrayList<String>();
	private List<String> expandOption = new ArrayList<String>();
	
	public ReadRequestImpl(RequestContext requestContext, String entityName, EntityMetadata entityMetadata, Map<String,List<String>> headers, Map<String, Object> keys, String httpMethod) {
		this.requestContext = requestContext;
		this.entityMetadata = entityMetadata;
		this.entityName = entityName;
		this.httpMethod = httpMethod;
		initialiseHeaders(headers);
		this.keys = keys;
	}
	
	@Override
	public Map<String, Object> getKeys() {
		return keys;
	}
	
	@Override
	public Map<String, Object> getSourceKeys() {
		return sourceKeys;
	}

	public void setSourceEntityName(String sourceEntityName) {
		this.sourceEntityName = sourceEntityName;
	}
	
	public void setSourceKeys(Map<String, Object>  sourceKeys) {
		this.sourceKeys = sourceKeys;
	}
	
	public void setKeys(Map<String, Object> keys) {
		this.keys = keys;
	}

	@Override
	public List<String> getSelectProperties() {
		Set<String> hs = new HashSet<>();
		hs.addAll(selectOption);
		selectOption.clear();
		selectOption.addAll(hs);
		return selectOption;
	}

	@Override
	public void addSelectProperties(List<String> selectedProperties) {
		for (String selectedProperty: selectedProperties ) {
			selectOption.add(selectedProperty);
		}
		
	}
	
	public void addExpandProperties(List<String> expandedProperties) {
		for (String expandedProperty: expandedProperties ) {
			expandOption.add(expandedProperty);
		}
		
	}

	@Override
	public List<String> getExpandProperties() {
		
		Set<String> hs = new HashSet<>();
		hs.addAll(expandOption);
		expandOption.clear();
		expandOption.addAll(hs);
		return expandOption;
	}
}
