/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.response;

import com.sap.cloud.sdk.service.prov.api.response.impl.CreateResponseBuilderImpl;
import com.sap.cloud.sdk.service.prov.api.response.impl.CreateResponseImpl;

/**
 * Provides the methods for creating a response in the case of a successful or failed create operation.
 */
public abstract class CreateResponse extends Response{	
	/**
	 * Returns a response builder using which the response header and the content can be populated
	 * in the event of a successful create operation. 
	 * @return A <code>CreateResponseBuilder</code> object	
	 */
	public static CreateResponseBuilder setSuccess(){
		return new CreateResponseBuilderImpl();
	}
	
	/**
	 * Populates error in the response in the event of a failed create operation,
	 * and returns the same.
	 * @param errorResponse An <code>ErrorResponse</code> object containing the error message and status code
	 * @return A <code>CreateResponse</code> object	containing the error
	 */
	public static CreateResponse setError(ErrorResponse errorResponse){
		return new CreateResponseImpl(errorResponse);
	}
}
