/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.response;

import java.util.List;
import java.util.Map;

import com.sap.cloud.sdk.service.prov.api.EntityData;

/**
 * Provides the methods for creating a response, populating its header and content,
 * and enabling audit logging in the case of a successful create operation.
 */
public interface CreateResponseBuilder extends ResponseBuilder {
	/**
	 * Adds headers in the CreateResponseBuilder object. If headers are already present in the CreateResponseBuilder object,
	 * the specified headers are added to the existing ones. The header name is case-insensitive.
	 * Note: The SDK framework might overwrite the values you add to the header in the final
	 * response that gets created.
	 * @param headers A {@link java.util.Map<java.lang.String,java.util.List<java.lang.String>>} containing the headers to be added
	 * @return A <code>CreateResponseBuilder</code> object containing the added headers
	 */
	public CreateResponseBuilder addHeaders(Map<String, List<String>> headers);
	
	/**
	 * Sets key-value pairs representing the properties of the created entity in the CreateResponseBuilder object.
	 * @param data A {@link java.util.Map Map} object that represents the created entity
	 * @return A <code>CreateResponseBuilder</code> object containing the created entity
	 */
	public CreateResponseBuilder setData(Map<String, Object> data);

	/**
	 * Sets an EntityData object corresponding to the created entity in the CreateResponseBuilder object.
	 * @param entityData An <code>EntityData</code> object that represents the created entity
	 * @return A <code>CreateResponseBuilder</code> object containing the created entity
	 */
	public CreateResponseBuilder setData(EntityData entityData);
	
	/**
	 * Sets a POJO object corresponding to the created entity in the CreateResponseBuilder object.
	 * @param pojo A POJO <code>Object</code> that represents the created entity
	 * @return A <code>CreateResponseBuilder</code> object containing the created entity
	 */
	public CreateResponseBuilder setData(Object pojo); 
	
	/**
	 * Sets a header with the specified name and value in the CreateResponseBuilder object.
	 * If the header is already present in the CreateResponseBuilder object,
	 * the new value overwrites the previous one. The header name is case-insensitive.
	 * Note: The SDK framework might overwrite the value you set in the header in the final
	 * response that gets created.
	 * @param name A <code>String</code> containing the name of the header
	 * @param value A <code>String</code> containing the header value
	 * @return A <code>CreateResponseBuilder</code> object containing the newly added or updated header
	 */
	public CreateResponseBuilder setHeader(String name, String value);
	
	/**
	 * Adds a header with the specified name and value in the CreateResponseBuilder object.
	 * If the header is already present in the CreateResponseBuilder object,
	 * the specified value is added to the existing values. The header name is case-insensitive.
	 * Note: The SDK framework might overwrite the value you add to the header in the final 
	 * response that gets created.
	 * @param name A <code>String</code> containing the name of the header
	 * @param value A <code>String</code> containing the additional header value
	 * @return A <code>CreateResponseBuilder</code> object containing the additional header
	 */
	public CreateResponseBuilder addHeader(String name, String value);
	
	/**
	 * Enables auditing for create operation.
	 * Please note that auditing is disabled by default.
	 * @param enable A <code>boolean</code> to enable or disable auditing
	 * @return A <code>CreateResponseBuilder</code> object containing the updated auditing attribute 
	 */
	@Deprecated
	public CreateResponseBuilder audit(boolean enable);
	
	/**
	 * Returns an instance of CreateResponse object.
	 * @return A <code>CreateResponse</code> object
	 */
	public CreateResponse response();
}
