/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.response;

import com.sap.cloud.sdk.service.prov.api.response.impl.DeleteResponseBuilderImpl;
import com.sap.cloud.sdk.service.prov.api.response.impl.DeleteResponseImpl;

/**
 * Provides the methods for creating a response in the case of a successful or failed delete operation.
 */
public abstract class DeleteResponse extends Response {
	/**
	 * Returns a response builder using which the response header and the content can be populated
	 * in the event of a successful delete operation. 
	 * @return A <code>DeleteResponseBuilder</code> object	
	 */
	public static DeleteResponseBuilder setSuccess(){
		return new DeleteResponseBuilderImpl();
	}
	
	/**
	 * Populates error in the response in the event of a failed delete operation,
	 * and returns the same.
	 * @param errorResponse An <code>ErrorResponse</code> object containing the error message and status code
	 * @return A <code>DeleteResponse</code> object	containing the error
	 */
	public static DeleteResponse setError(ErrorResponse errorResponse){
		return new DeleteResponseImpl(errorResponse);
	}
}
