/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.response;

import java.util.List;
import java.util.Map;

/**
 * Provides the methods for creating a response, populating its header,
 * and enabling audit logging in the case of a successful delete operation.
 */
public interface DeleteResponseBuilder extends ResponseBuilder {
	/**
	 * Adds headers in the DeleteResponseBuilder object. If headers are already present in the DeleteResponseBuilder object,
	 * the specified headers are added to the existing ones. The header name is case-insensitive.
	 * Note: The SDK framework might overwrite the values you add to the header in the final
	 * response that gets created.
	 * @param headers A {@link java.util.Map<java.lang.String,java.util.List<java.lang.String>>} containing the headers to be added
	 * @return A <code>DeleteResponseBuilder</code> object containing the added headers
	 */
	public DeleteResponseBuilder addHeaders(Map<String, List<String>> headers);
	
	/**
	 * Sets a header with the specified name and value in the DeleteResponseBuilder object.
	 * If the header is already present in the DeleteResponseBuilder object,
	 * the new value overwrites the previous one. The header name is case-insensitive.
	 * Note: The SDK framework might overwrite the value you set in the header in the final
	 * response that gets created.
	 * @param name A <code>String</code> containing the name of the header
	 * @param value A <code>String</code> containing the header value
	 * @return A <code>DeleteResponseBuilder</code> object containing the newly added or updated header
	 */
	public DeleteResponseBuilder setHeader(String name, String value);
	
	/**
	 * Adds a header with the specified name and value in the DeleteResponseBuilder object.
	 * If the header is already present in the DeleteResponseBuilder object,
	 * the specified value is added to the existing values. The header name is case-insensitive.
	 * Note: The SDK framework might overwrite the value you add to the header in the final 
	 * response that gets created.
	 * @param name A <code>String</code> containing the name of the header
	 * @param value A <code>String</code> containing the additional header value
	 * @return A <code>DeleteResponseBuilder</code> object containing the additional header
	 */
	public DeleteResponseBuilder addHeader(String name, String value);
	
	/**
	 * Enables auditing for delete operation.
	 * Please note that auditing is disabled by default.
	 * @param enable A <code>boolean</code> to enable or disable auditing
	 * @return A <code>DeleteResponseBuilder</code> object containing the updated auditing attribute 
	 */
	@Deprecated
	public DeleteResponseBuilder audit(boolean enable);
	
	/**
	 * Returns an instance of DeleteResponse object.
	 * @return A <code>DeleteResponse</code> object
	 */
	public DeleteResponse response();
}
