/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.response;

import com.sap.cloud.sdk.service.prov.api.response.impl.ErrorResponseBuilderImpl;

/**
 * Provides the method for creating a response builder in the case of a failed operation.
 */
public interface ErrorResponse {
	/**
	 * Returns a response builder using which an error message and the status code can be populated
	 * in the event of a failed operation. 
	 * @return A <code>ErrorResponseBuilder</code> object	
	 */
	public static ErrorResponseBuilder getBuilder() {
		return new ErrorResponseBuilderImpl();
	}
}
