/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.response;

import com.sap.cloud.sdk.service.prov.api.response.impl.OperationResponseBuilderImpl;
import com.sap.cloud.sdk.service.prov.api.response.impl.OperationResponseImpl;

/**
 * Provides the methods for creating a response in the case of a successful or failed operation.
 */
public abstract class OperationResponse extends Response {	
	
	/**
	 * Returns a response builder using which the response header and the content can be populated
	 * in the event of a successful operation. 
	 * @return An <code>OperationResponseBuilder</code> object	
	 */
	public static OperationResponseBuilder setSuccess() {
		return new OperationResponseBuilderImpl();
	}
	/**
	 * Populates an error in the response in the event of a failed operation,
	 * and returns the same.
	 * @param errorResponse An <code>ErrorResponse</code> object containing the error message and status code
	 * @return An <code>OperationResponse</code> object	containing the error
	 */
	public static OperationResponse setError(ErrorResponse errorResponse) {
		return new OperationResponseImpl(errorResponse);
	}

}
