/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.response;

import java.util.List;
import java.util.Map;

import com.sap.cloud.sdk.service.prov.api.EntityData;

public interface OperationResponseBuilder extends ResponseBuilder {
	
	/**
	 * Can be used to set the response Entity, Array of Entities where the entity is represented by a POJO.
	 * If returning a single entity, create a list with a single POJO.
	 * If returning a collection of entities, create a list of POJOs. 
	 * @param A single or array of Java objects.
	 * @return OperationResponseBuilder to build the response
	 */	
	public abstract OperationResponseBuilder setData(List<Object> data);
	/**
	 * Can be used to set the response Entity, Array of Entities.
	 * If returning a single entity, create a list with single element.
	 * If returning a collection of entities, create a list of entities. 
	 * @param A single or array of EntityData
	 * @return OperationResponseBuilder to build the response
	 */	
	public abstract OperationResponseBuilder setEntityData(List<EntityData> entityData);
	
	/**
	 * Can be used to set the response Complex Types, Array of ComplexTypes.
	 * If returning a single complex type, create a list with single Map.
	 * If returning a collection of complex types, create a list of complex type maps.
	 * @param A single or array of Complex Types
	 * @return OperationResponseBuilder to build the response
	 */	
	public abstract OperationResponseBuilder setComplexData(List<Map<String, Object>> complexData);
	
	/**
	 * Can be used to set the response single primitive type or collection of primitive types.
	 * If returning a single primitive type, create a list with single primitive type.
	 * If returning a collection of primitive types, create a list of primitive types.
	 * @param A single or array of Primitive type Objects
	 * @return OperationResponseBuilder to build the response
	 */
	public abstract OperationResponseBuilder setPrimitiveData(List<Object> primitiveData);
	
	/**
	 * Adds headers in the OperationResponseBuilder object. If headers are already present in the OperationResponseBuilder object,
	 * the specified headers are added to the existing ones. The header name is case-insensitive.
	 * Note: The SDK framework might overwrite the values you add to the header in the final
	 * response that gets created.
	 * @param headers A {@link java.util.Map<java.lang.String,java.util.List<java.lang.String>>} containing the headers to be added
	 * @return A <code>OperationResponseBuilder</code> object containing the added headers
	 */
	public OperationResponseBuilder addHeaders(Map<String, List<String>> headers);

	/**
	 * Sets a header with the specified name and value in the OperationResponseBuilder object.
	 * If the header is already present in the OperationResponseBuilder object,
	 * the new value overwrites the previous one. The header name is case-insensitive.
	 * Note: The SDK framework might overwrite the value you set in the header in the final
	 * response that gets created.
	 * @param name A <code>String</code> containing the name of the header
	 * @param value A <code>String</code> containing the header value
	 * @return A <code>OperationResponseBuilder</code> object containing the newly added or updated header
	 */
	public OperationResponseBuilder setHeader(String name, String value);
	
	/**
	 * Adds a header with the specified name and value in the OperationResponseBuilder object.
	 * If the header is already present in the OperationResponseBuilder object,
	 * the specified value is added to the existing values. The header name is case-insensitive.
	 * Note: The SDK framework might overwrite the value you add to the header in the final 
	 * response that gets created.
	 * @param name A <code>String</code> containing the name of the header
	 * @param value A <code>String</code> containing the additional header value
	 * @return A <code>OperationResponseBuilder</code> object containing the additional header
	 */
	public OperationResponseBuilder addHeader(String name, String value);
	
	/**
	 * Use this method to build the OperationResponse from the builder.
	 * @return OperationResponse which can be returned
	 */
	public abstract OperationResponse response();
	
}
