/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.response;

import com.sap.cloud.sdk.service.prov.api.response.impl.QueryResponseBuilderImpl;
import com.sap.cloud.sdk.service.prov.api.response.impl.QueryResponseImpl;

/**
 * Provides the methods for creating a response in the case of a successful or failed query operation.
 */
public abstract class QueryResponse extends Response{
	/**
	 * Returns a response builder using which the response header and the content can be populated
	 * in the event of a successful query operation. 
	 * @return A <code>QueryResponseBuilder</code> object	
	 */
	public static QueryResponseBuilder setSuccess(){
		return new QueryResponseBuilderImpl();
	}
	
	/**
	 * Populates error in the response in the event of a failed query operation,
	 * and returns the same.
	 * @param errorResponse An <code>ErrorResponse</code> object containing the error message and status code
	 * @return A <code>QueryResponse</code> object containing the error
	 */
	public static QueryResponse setError(ErrorResponse errorResponse){
		return new QueryResponseImpl(errorResponse);
	}
}
