/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.response;

import com.sap.cloud.sdk.service.prov.api.response.impl.ReadResponseBuilderImpl;
import com.sap.cloud.sdk.service.prov.api.response.impl.ReadResponseImpl;

/**
 * Provides the methods for creating a response in the case of a successful or failed read operation.
 */
public abstract class ReadResponse extends Response {	
	/**
	 * Returns a response builder using which the response header and the content can be populated
	 * in the event of a successful read operation. 
	 * @return A <code>ReadResponseBuilder</code> object	
	 */
	public static ReadResponseBuilder setSuccess() {
		return new ReadResponseBuilderImpl();
	}
	
	/**
	 * Populates error in the response in the event of a failed read operation,
	 * and returns the same.
	 * @param errorResponse An <code>ErrorResponse</code> object containing the error message and status code
	 * @return A <code>ReadResponse</code> object containing the error
	 */
	public static ReadResponse setError(ErrorResponse errorResponse) {
		return new ReadResponseImpl(errorResponse);
	}
}
