/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.response;

import com.sap.cloud.sdk.service.prov.api.response.impl.UpdateResponseBuilderImpl;
import com.sap.cloud.sdk.service.prov.api.response.impl.UpdateResponseImpl;

/**
 * Provides the methods for creating a response in the case of a successful or failed update operation.
 */
public abstract class UpdateResponse extends Response {	
	/**
	 * Returns a response builder using which the response header and the content can be populated
	 * in the event of a successful update operation. 
	 * @return An <code>UpdateResponseBuilder</code> object	
	 */
	public static UpdateResponseBuilder setSuccess(){
		return new UpdateResponseBuilderImpl();
	}
	
	/**
	 * Populates error in the response in the event of a failed update operation,
	 * and returns the same.
	 * @param errorResponse An <code>ErrorResponse</code> object containing the error message and status code
	 * @return An <code>UpdateResponse</code> object containing the error
	 */
	public static UpdateResponse setError(ErrorResponse errorResponse){
		return new UpdateResponseImpl(errorResponse);
	}
	
}
