/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.response.impl;

import java.util.List;
import java.util.Map;

import com.sap.cloud.sdk.service.prov.api.EntityData;
import com.sap.cloud.sdk.service.prov.api.EntityMetadata;
import com.sap.cloud.sdk.service.prov.api.response.CreateResponse;
import com.sap.cloud.sdk.service.prov.api.response.CreateResponseAccessor;
import com.sap.cloud.sdk.service.prov.api.util.DataConversionUtility;

public class CreateResponseAccessorImpl implements CreateResponseAccessor {

	private Object data;
	private EntityMetadata entityMetadata;

	public CreateResponseAccessorImpl(EntityData entityData, Map<String, List<String>> headers) {
		this.data = entityData;
		// this.headers = headers;
	}

	public CreateResponseAccessorImpl(EntityMetadata em, Object data) {
		entityMetadata = em;
		this.data = data;
	}

	public EntityData getEntityData() {
		return DataConversionUtility.convertToEntityData(data, entityMetadata.getName(), entityMetadata.getKeyNames());
	}

	public <T> T getDataAs(Class<T> clazz) {
		return DataConversionUtility.convertToClass(clazz, data);
	}

	public CreateResponse getOriginalResponse() {
		return CreateResponse.setSuccess().setData(data).response();
	}

}
