/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.response.impl;

import java.util.List;
import java.util.Map;

import com.sap.cloud.sdk.service.prov.api.response.CreateResponse;
import com.sap.cloud.sdk.service.prov.api.response.ErrorResponse;

public class CreateResponseImpl extends CreateResponse {
	private Object data; 
	private ErrorResponse errorResponse;
	private Map<String, List<String>> headers;
	private boolean enableAuditing = false;
	
	public CreateResponseImpl() {
	}

	public void setData( Object data) {
		this.data = data;
	}
	
	public CreateResponseImpl(ErrorResponse error) {
		this.errorResponse = error;
	}

	public ErrorResponse getErrorResponse() {
		return errorResponse;
	}
	
	public Object getData() {
		return data;
	}
	
	public void setHeaders(Map<String, List<String>> headers){
		this.headers = headers;
	}
	
	public Map<String, List<String>> getHeaders(){
		return headers;
	}
	
	@Deprecated
	public void audit(boolean enable) {
		this.enableAuditing = enable;
	}
	
	@Deprecated
	public boolean isAuditingEnabled(){
		return this.enableAuditing;
	}
}
