/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.response.impl;

import java.util.ArrayList;
import java.util.List;

import com.sap.cloud.sdk.service.prov.api.Message;
import com.sap.cloud.sdk.service.prov.api.Severity;
import com.sap.cloud.sdk.service.prov.api.request.MessageContainerImpl;
import com.sap.cloud.sdk.service.prov.api.response.ErrorResponse;
import com.sap.cloud.sdk.service.prov.api.response.ErrorResponseBuilder;

public class ErrorResponseBuilderImpl implements ErrorResponseBuilder {
	boolean addMessagesFromContainer = false;
	private Severity[] allSeverities = {Severity.ERROR, Severity.INFO, Severity.WARNING, Severity.SUCCESS};
	List<Object> errorDetails = new ArrayList<>();
	private int statuscode;
	private String errorCode;
	private String message;
	private Throwable throwable;
	private boolean isErrorCodeSet = false;

	public ErrorResponseBuilder setCause(Throwable throwable) {
		this.throwable = throwable;
		return this;
	}

	public ErrorResponseBuilder setStatusCode(int statusCode) {
		this.statuscode = statusCode;
		return this;
	}
	
	@Override
	public ErrorResponseBuilder setMessage(String messageKey, Object... params) {
		if (!isErrorCodeSet) {
			errorCode = messageKey;
		}
		this.message = MessageContainerImpl.getLocalizedMessage(messageKey, params);
		return this;
	}

	public Throwable getCause() {
		return throwable;
	}

	public int getStatuscode() {
		return statuscode;
	}

	public String getMessage() {
		return message;
	}

	@Override
	public ErrorResponse response() {
		return new ErrorResponseImpl(statuscode, errorCode, message, throwable, errorDetails);
	}

	@Override
	public ErrorResponseBuilder addContainerMessages(Severity... severities) {
		if(severities == null || severities.length == 0)
			severities = allSeverities;
		errorDetails.add(severities);
		
		return this;
	}

	@Override
	public ErrorResponseBuilder addErrorDetail(String code, String target, Object... params) {
		errorDetails.add(new Message(code, MessageContainerImpl.getLocalizedMessage(code, params), target, Severity.ERROR));
		return this;
	}
	
	@Override
	public ErrorResponseBuilder setErrorCode(String errorCode) {
		this.errorCode = errorCode;
		isErrorCodeSet = true;
		return this;
	}
}
