/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.response.impl;

import com.sap.cloud.sdk.service.prov.api.response.MediaReadResponse;
import com.sap.cloud.sdk.service.prov.api.response.MediaReadResponseBuilder;

public class MediaReadResponseBuilderImpl implements MediaReadResponseBuilder {
	private byte[] mediaValue;
	private String mediaType;
	

	@Override
	public MediaReadResponseBuilder setMediaData(byte[] mediaData, String mediaType) {
			this.mediaValue = mediaData;
			this.mediaType = mediaType;
			return this;
	}
	@Override
	public MediaReadResponse response() {
		MediaReadResponseImpl readResponse = new MediaReadResponseImpl();
		readResponse.setMediaValue(mediaValue);
		readResponse.setMediaType(mediaType);
		return readResponse;
	}

}
