/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.response.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cloud.sdk.service.prov.api.EntityData;
import com.sap.cloud.sdk.service.prov.api.response.OperationResponse;
import com.sap.cloud.sdk.service.prov.api.response.OperationResponseBuilder;


public class OperationResponseBuilderImpl implements OperationResponseBuilder{
	private static Logger log = LoggerFactory.getLogger(OperationResponseBuilderImpl.class);
	private List data; // Can be either a list of entityData or a list of Pojo.
	private List<Map<String, Object>> complexData;
	private List<Object> primitiveData;
	private Map<String, List<String>> headers = new HashMap<>();

	@Override
	public OperationResponseBuilder setEntityData(List<EntityData> data){
		this.data = data;
		return this;
	}
	
	@Override
	public OperationResponseBuilder setData(List data){
		this.data = data;
		return this;
	}

	@Override
	public OperationResponseBuilder setComplexData(List<Map<String, Object>> data) {
		this.complexData = data;
		return this;
	}

	@Override
	public OperationResponseBuilder setPrimitiveData(List<Object> data) {
		this.primitiveData = data;
		return this;
	}

	@Override
	public OperationResponseBuilder addHeaders(Map<String, List<String>> headers) {
		if (headers != null && !headers.isEmpty()) {
			if (this.headers.isEmpty()) {
				this.headers.putAll(headers);
			} else {
				for (Map.Entry<String, List<String>> entry: headers.entrySet()) {
					if (entry.getValue() != null && !entry.getValue().isEmpty()) {
						String headerName = getHeaderName(entry.getKey());
						if (this.headers.get(headerName) == null) {
							this.headers.put(headerName, new ArrayList<String>(entry.getValue()));
						} else {
							this.headers.get(headerName).addAll(entry.getValue());
						}
					}
				}
			}
		}
		return this;
	}

	@Override
	public OperationResponseBuilder setHeader(String name, String value) {
		String headerName = getHeaderName(name);
		List<String> valueList = new ArrayList<String>();
		valueList.add(value);
		if (log.isDebugEnabled()) {log.debug("Set header name "+name+" with value "+value+".");}
		headers.put(headerName, valueList);
		return this;
	}

	@Override
	public OperationResponseBuilder addHeader(String name, String value) {
		String headerName = getHeaderName(name);
		List<String> valueList = headers.get(headerName);
		if (valueList == null) {
			valueList = new ArrayList<String>();
		}
		valueList.add(value);
		if (log.isDebugEnabled()) {log.debug("Replace header name "+name+". Setting name "+headerName+" with value "+value+".");}
		headers.put(headerName, valueList);
		return this;
	}
	
	@Override
	public OperationResponse response() {
		OperationResponseImpl functionResponse = new OperationResponseImpl();
		functionResponse.setEntityData(data);
		functionResponse.setComplexData(complexData);
		functionResponse.setPrimitiveData(primitiveData);
		functionResponse.setHeaders(headers);		
		return functionResponse;
	}

	protected String getHeaderName(String name) {
		//Header names are case insensitive
		if(name == null || "".equals(name.trim()) || headers == null){
			return name;
		}
		for (String headerName : headers.keySet()) {
			if (headerName.equalsIgnoreCase(name)) {
				return headerName;
			}
		}
		return name;
	}
	
}
