/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.response.impl;

import java.util.List;
import java.util.Map;

import com.sap.cloud.sdk.service.prov.api.response.ErrorResponse;
import com.sap.cloud.sdk.service.prov.api.response.OperationResponse;


public class OperationResponseImpl extends OperationResponse{

	private ErrorResponse errorResponse;
	private List<Object> data;
	private List<Map<String, Object>> complexData;
	private List<Object> primitiveData;
	private boolean enableAuditing = false;

	public OperationResponseImpl(ErrorResponse error) {
		this.errorResponse = error;
	}

	public OperationResponseImpl() {
	}

	public ErrorResponse getErrorResponse() {
		return errorResponse;
	}

	public int getStatusCode() {
		return statusCode;
	}

	public void setStatusCode(int statusCode) {
		this.statusCode = statusCode;
	}
	
	// Here 'Entity' is as opposed to  Complex, or primitive. The data can be either EntityData or Pojo.
	public void setEntityData(List data){ 
		this.data = data;
	}


	public void setComplexData(List<Map<String, Object>> data) {
		this.complexData = data;
	}


	public void setPrimitiveData(List<Object> data) {
		this.primitiveData = data;
	}
	
	// Here 'Entity' is as opposed to  Complex, or primitive. The data can be either EntityData or Pojo.
	public List getEntityData() {
		return data;
	}

	public List<Map<String, Object>> getComplexData() {
		return complexData;
	}
	
	public List<Object> getPrimitiveData() {
		return primitiveData;
	}
	
	@Deprecated
	public void audit(boolean enable) {
		this.enableAuditing = enable;
	}
	@Deprecated
	public boolean isAuditingEnabled(){
		return this.enableAuditing;
	}
	
	public void setHeaders(Map<String, List<String>> headers){
		this.headers = headers;
	}
	
	public Map<String, List<String>> getHeaders(){
		return headers;
	}
}
