/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.response.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cloud.sdk.service.prov.api.EntityData;
import com.sap.cloud.sdk.service.prov.api.response.QueryResponse;
import com.sap.cloud.sdk.service.prov.api.response.QueryResponseBuilder;

public class QueryResponseBuilderImpl implements QueryResponseBuilder {
	private static Logger log = LoggerFactory.getLogger(QueryResponseBuilderImpl.class);
	private List<?> data;
	private Map<String, List<String>> headers = new HashMap<>();
	private boolean enable = false;
	private EntityData auditEntityData;
	private List<String> auditProps;
	private boolean isTopDone;
	private boolean isSkipDone;
	private int inlineCount = -1;
	private int count = -1;
	
	@Override
	public QueryResponseBuilder setDataAsMap(List<Map<String,Object>> data) {
		this.data = data;
		return this;
	}

	@Override
	public QueryResponseBuilder setEntityData(List<EntityData> data) {
		this.data = data;
		return this;
	}

	@Override
	public QueryResponseBuilder setData(List<?> data) {
		this.data = data;
		return this;
	}

	@Override
	public QueryResponseBuilder addHeaders(Map<String, List<String>> headers) {
		if (headers != null && !headers.isEmpty()) {
			if (this.headers.isEmpty()) {
				this.headers.putAll(headers);
			} else {
				for (Map.Entry<String, List<String>> entry: headers.entrySet()) {
					if (entry.getValue() != null && !entry.getValue().isEmpty()) {
						String headerName = getHeaderName(entry.getKey());
						if (this.headers.get(headerName) == null) {
							this.headers.put(headerName, new ArrayList<String>(entry.getValue()));
						} else {
							this.headers.get(headerName).addAll(entry.getValue());
						}
					}
				}
			}
		}
		return this;
	}

	@Override
	public QueryResponseBuilder setHeader(String name, String value) {
		String headerName = getHeaderName(name);
		List<String> valueList = new ArrayList<String>();
		valueList.add(value);
		if (log.isDebugEnabled()) {log.debug("Set header name "+name+" with value "+value+".");}
		headers.put(headerName, valueList);
		return this;
	}

	@Override
	public QueryResponseBuilder addHeader(String name, String value) {
		String headerName = getHeaderName(name);
		List<String> valueList = headers.get(headerName);
		if (valueList == null) {
			valueList = new ArrayList<String>();
		}
		valueList.add(value);
		if (log.isDebugEnabled()) {log.debug("Replace header name "+name+". Setting name "+headerName+" with value "+value+".");}
		headers.put(headerName, valueList);
		return this;
	}

	@Override
	public QueryResponse response() {
		QueryResponseImpl queryResponse = new QueryResponseImpl();
		queryResponse.setData(data);
		queryResponse.setHeaders(headers);
		queryResponse.setSkipDone(isSkipDone);
		queryResponse.setTopDone(isTopDone);
		queryResponse.setInlineCount(inlineCount);
		queryResponse.audit(enable);
		queryResponse.audit(auditEntityData, auditProps);
		queryResponse.setCount(count);
		return queryResponse;
	}

	@Deprecated
	@Override
	public QueryResponseBuilder audit(boolean enable) {
		this.enable = enable;
		return this;
	}

	@Deprecated
	@Override
	public QueryResponseBuilder audit(EntityData auditEntityData, List<String> properties) {
		this.auditEntityData = auditEntityData;this.auditProps = properties;
		return this;
	}

	@Override
	public QueryResponseBuilder setTopDone(boolean isTopDone) {
		this.isTopDone = isTopDone;
		return this;
	}
	
	@Override
	public QueryResponseBuilder setSkipDone(boolean isSkipDone) {
		this.isSkipDone = isSkipDone;
		return this;
	}
	
	protected String getHeaderName(String name) {
		//Header names are case insensitive
		if(name == null || "".equals(name.trim()) || headers == null){
			return name;
		}
		for (String headerName : headers.keySet()) {
			if (headerName.equalsIgnoreCase(name)) {
				return headerName;
			}
		}
		return name;
	}

	@Override
	public QueryResponseBuilder setInlineCount(int inlineCount) {
		this.inlineCount = inlineCount;
		return this;
	}
	
	@Override
	public QueryResponseBuilder setCount(int count) {
		this.count = count;
		return this;
	}

	public int getCount() {
		return count;
	}
}
