/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.response.impl;

import com.sap.cloud.sdk.service.prov.api.EntityData;
import com.sap.cloud.sdk.service.prov.api.EntityMetadata;
import com.sap.cloud.sdk.service.prov.api.response.ReadResponse;
import com.sap.cloud.sdk.service.prov.api.response.ReadResponseAccessor;
import com.sap.cloud.sdk.service.prov.api.util.DataConversionUtility;

public class ReadResponseAccessorImpl implements ReadResponseAccessor {

	private Object data;
	private EntityMetadata entityMetadata;
	
	public ReadResponseAccessorImpl(EntityMetadata em, Object data) {
		entityMetadata = em;
		this.data = data;
	}
	
	public EntityData getEntityData() {
		return DataConversionUtility.convertToEntityData(data, entityMetadata.getName(), entityMetadata.getKeyNames());
	}

	public <T> T getDataAs(Class<T> clazz) {
		return DataConversionUtility.convertToClass(clazz, data);
	}

	@Override
	public ReadResponse getOriginalResponse() {
		return ReadResponse.setSuccess().setData(data).response();
	}

}
