/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.response.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cloud.sdk.service.prov.api.response.ErrorResponse;
import com.sap.cloud.sdk.service.prov.api.response.ReadResponse;


public class ReadResponseImpl extends ReadResponse {
	private static Logger log = LoggerFactory.getLogger(ReadResponseImpl.class);
	private Object data; 
	private ErrorResponse errorResponse;
	private boolean enableAuditing = false;
	
	public ReadResponseImpl() { 
	}
	
	public ReadResponseImpl(ErrorResponse error) {
		this.errorResponse = error;
	}

	public ErrorResponse getErrorResponse() {
		return errorResponse;
	}

	public void setData( Object data) {
		this.data = data;
	}
	
	public Object getData() {
		return data; 
	}
	
	public int getStatusCode() {
		return statusCode;
	}
	
	public void setStatusCode(int statusCode) {
		this.statusCode = statusCode;
	}
	
	@Deprecated
	public void audit(boolean enable) {
		this.enableAuditing = enable;
	}
	
	@Deprecated
	public boolean isAuditingEnabled(){
		return this.enableAuditing;
	}
	
	public void setHeaders(Map<String, List<String>> headers){
		this.headers = headers;
	}
	
	public Map<String, List<String>> getHeaders(){
		return headers;
	}

	public void setHeader(String name, String value) {
		removeHeader(name);
		List<String> valueList = new ArrayList<String>();
		valueList.add(value);
		if (log.isDebugEnabled()) {log.debug("Set header name "+name+" with value "+value+".");}
		headers.put(name, valueList);
	}
	
	public List<String> removeHeader(String name) {
		String headerName = getHeaderName(name);
		if (log.isDebugEnabled()) {log.debug("Remove header name "+name+". Removing header name "+headerName+".");}
		return headers.remove(headerName);
	}
	
	public String getHeader(String name) {
		if(name == null || "".equals(name.trim()) || headers == null){
			return null;
		}
		String headerName = getHeaderName(name);
		List<String> valueList = headers.get(headerName);
		return (valueList == null ? null : (valueList.size() > 0 ? valueList.get(0) : null));
	}
	
	protected String getHeaderName(String name) {
		//Header names are case insensitive
		if(name == null || "".equals(name.trim()) || headers == null){
			return name;
		}
	    for (String headerName : headers.keySet()) {
	      if (headerName.equalsIgnoreCase(name)) {
	        return headerName;
	      }
	    }
	    return name;
	}
}
