/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.response.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cloud.sdk.service.prov.api.response.UpdateResponse;
import com.sap.cloud.sdk.service.prov.api.response.UpdateResponseBuilder;

public class UpdateResponseBuilderImpl implements UpdateResponseBuilder {
	private static Logger log = LoggerFactory.getLogger(UpdateResponseBuilderImpl.class);
	private Map<String, List<String>> headers = new HashMap<>();
	private boolean enable = false;

	@Override
	public UpdateResponseBuilder addHeaders(Map<String, List<String>> headers) {
		if (headers != null && !headers.isEmpty()) {
			if (this.headers.isEmpty()) {
				this.headers.putAll(headers);
			} else {
				for (Map.Entry<String, List<String>> entry: headers.entrySet()) {
					if (entry.getValue() != null && !entry.getValue().isEmpty()) {
						String headerName = getHeaderName(entry.getKey());
						if (this.headers.get(headerName) == null) {
							this.headers.put(headerName, new ArrayList<String>(entry.getValue()));
						} else {
							this.headers.get(headerName).addAll(entry.getValue());
						}
					}
				}
			}
		}
		return this;
	}

	@Override
	public UpdateResponseBuilder setHeader(String name, String value) {
		String headerName = getHeaderName(name);
		List<String> valueList = new ArrayList<String>();
		valueList.add(value);
		if (log.isDebugEnabled()) {log.debug("Set header name "+name+" with value "+value+".");}
		headers.put(headerName, valueList);
		return this;
	}

	@Override
	public UpdateResponseBuilder addHeader(String name, String value) {
		String headerName = getHeaderName(name);
		List<String> valueList = headers.get(headerName);
		if (valueList == null) {
			valueList = new ArrayList<String>();
		}
		valueList.add(value);
		if (log.isDebugEnabled()) {log.debug("Replace header name "+name+". Setting name "+headerName+" with value "+value+".");}
		headers.put(headerName, valueList);
		return this;
	}

	@Override
	public UpdateResponse response() {
		UpdateResponseImpl updateResponse = new UpdateResponseImpl();
		updateResponse.setHeaders(this.headers);
		updateResponse.audit(enable);
		return updateResponse;
	}

	@Deprecated
	@Override
	public UpdateResponseBuilder audit(boolean enable) {
		this.enable = enable;
		return this;
	}

	protected String getHeaderName(String name) {
		//Header names are case insensitive
		if(name == null || "".equals(name.trim()) || headers == null){
			return name;
		}
		for (String headerName : headers.keySet()) {
			if (headerName.equalsIgnoreCase(name)) {
				return headerName;
			}
		}
		return name;
	}
}
