/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.security;

import java.util.List;

/**
 * Bean class which contains the restriction details of the entity.
 *
 * Example restriction details.
 *    {
 *         "grant": [
 *          "READ",
 *          "WRITE"
 *        ],
 *        "to": "admin",
 *        "where": "buyer = $user"
 *    }
 *
 *
 */
public class AccessGrantDetails {

	private List<String> grant;
	private String to;
	private Object where;

	public List<String> getGrant() {
		return grant;
	}
	public void setGrant(List<String> grant) {
		this.grant = grant;
	}
	public String getTo() {
		return to;
	}
	public void setTo(String to) {
		this.to = to;
	}

	/*
	    Its bug in cds compiler  which  generates  csn.json  as below
	    "where": {
            "=": "ProductDescription = '3M A4 Printing Paper'"
          }
          instead of
          "where":"ProductDescription = '3M A4 Printing Paper'"
          this occurs when single quotes is present in value
          so  object is created in csn.json instead of simple string as value

          therefore as workaround we have converted where to object type and in getter we parse the value from object
          and return string if its an object
          Therefore remove {== and remove }
          {==ProductDescription = '3M A4 Printing Paper'}
	 */
	public String getWhere() {
        if(where == null){
            return null;
        }
        // here where is a simple string
        if( where instanceof String) {
			return where+"";
		}
		// here where is  json object
		Object x=where;
		String s=x+"";
		return s.replaceAll("\\{\\=\\=","").replaceAll("\\}","");
	}
	public void setWhere(Object where) {
		this.where = where;
	}
	@Override
	public String toString() {
		return "AccessGrantDetails [grant=" + grant + ", to=" + to + ", where=" + getWhere() + "]";
	}

}
 