/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.security;

import com.google.gson.JsonElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * AuthorizationDecorator which allows easy extension if new functionalities have to be added to existing 
 * IAuthorization. 
 * 
 */
public class AuthorizationDecorator extends Authorization{
    private final static Logger log = LoggerFactory.getLogger(AuthorizationDecorator.class);
	
	private Authorization authorization;
	
	public AuthorizationDecorator(Authorization authorization) {
		this.authorization = authorization;
	}

	/* (non-Javadoc)
	 * @see com.sap.cloud.sdk.service.prov.api.security.Authorization#isAuthenticatedUser(java.lang.String)
	 */
	@Override
	public boolean isAuthenticatedUser(String serviceName) {
		boolean isAuthenticated = authorization.isAuthenticatedUser(serviceName);		
        log.debug("User is authenticated for Service: {} {}", serviceName, isAuthenticated);
        return isAuthenticated;
	}

	/* (non-Javadoc)
	 * @see com.sap.cloud.sdk.service.prov.api.security.Authorization#isRegisteredUser(java.lang.String)
	 */
	@Override
	public boolean isRegisteredUser(String serviceName) {
		return authorization.isRegisteredUser(serviceName);
	}

	/* (non-Javadoc)
	 * @see com.sap.cloud.sdk.service.prov.api.security.Authorization#hasEntityAccess(java.lang.String, java.lang.String)
	 */
	@Override
	public boolean hasEntityAccess(String entityName, String operation) {
		return authorization.hasEntityAccess(entityName, operation);
	}

	/* (non-Javadoc)
	 * @see com.sap.cloud.sdk.service.prov.api.security.Authorization#getUserName()
	 */
	@Override
	public String getUserName() {
		return authorization.getUserName();
	}

	/* (non-Javadoc)
	 * @see com.sap.cloud.sdk.service.prov.api.security.Authorization#getUserId()
	 */
	@Override
	public String getUserId() {
		return authorization.getUserId();
	}

	/* (non-Javadoc)
	 * @see com.sap.cloud.sdk.service.prov.api.security.Authorization#hasUserRole(java.lang.String)
	 */
	@Override
	public boolean hasUserRole(String roleName) {
		return authorization.hasUserRole(roleName);
	}

	/* (non-Javadoc)
	 * @see com.sap.cloud.sdk.service.prov.api.security.Authorization#getUserAttribute(java.lang.String)
	 */
	@Override
	public String getUserAttribute(String attributeName) {
		return authorization.getUserAttribute(attributeName);
	}

}
