/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.security;

import java.util.List;

/**
 * Bean class which contains authorization details of a Odata service/entity.
 * 
 * Example of Service details.
 * 
 * 		 {
 *     		"kind": "service",
 *    		"requires": ["authenticated-user","RoleA"]
 *     	 }
 * 
 * Example of Entity details.
 *   
 *    {
 * 		"kind": "entity",
   		"restricts": [
 *    					{
 *        					 "grant": [
 *          							"READ",
 *          							"WRITE"
 *        							  ],
 *        					 "to": "admin",
 *        					 "where": "buyer = $user"
 *    					}
 *    				]
 * 
 *
 */
public class AuthorizationDetails {

	private String kind;
	private List<String> requires;
	private List<AccessGrantDetails> restrict;
	
	public String getKind() {
		return kind;
	}
	public void setKind(String kind) {
		this.kind = kind;
	}
	public List<String> getRequires() {
		return requires;
	}
	public void setRequires(List<String> requires) {
		this.requires = requires;
	}
	public List<AccessGrantDetails> getRestrict() {
		return restrict;
	}
	public void setRestrict(List<AccessGrantDetails> restrict) {
		this.restrict = restrict;
	}
	
	@Override
	public String toString() {
		return "AuthorizationDetails [kind=" + kind + ", requires=" + requires + ", restrict=" + restrict + "]";
	}
}
