package com.sap.cloud.sdk.service.prov.api.security;

import static com.sap.cloud.sdk.service.prov.api.internal.SQLMapping.convertToUpperCaseIfRequired;
import static com.sap.cloud.sdk.service.prov.api.internal.SQLMapping.isPlainSqlMapping;
import static com.sap.cloud.sdk.service.prov.api.internal.SQLMapping.quoteIfRequired;
import static com.sap.cloud.sdk.service.prov.api.internal.SQLMapping.replaceDotIfRequired;
import static com.sap.cloud.sdk.service.prov.api.security.Operator.getEncodedValueMap;
import static com.sap.cloud.sdk.service.prov.api.security.Operator.getValueMap;

import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.service.prov.api.internal.CSNUtil;

public class AuthorizationExpressionParser {
    private static final String $ = "$";
    private static final int ONE = 1;
    private static final String LEFT_PARANTHESIS = "(";
    private static final String RIGHT_PARANTHESIS = ")";
    private static final String LEFT_CURLY_PARANTHESIS = " { ";
    private static final String RIGHT_CURLY_PARANTHESIS = " } ";
    private static final String COMMA = ",";

    private static final String SPACE = " ";
    private static final String HANA_PARAM_PLACEHOLDER = "?";
    private static final String ALIAS_Prefix = "ROOT_ENTITY_SELECT_ALIAS.PATH_FROM_ROOT.";
    private static final String NULL = "null";
    private static final String AND = "and";
    private static final String OR = "or";
    private static final String NOT = "not";
    private static final String WHERE = " where ";
    private static final String FROM = " from ";
    private static final String SELECT = " select ";
    private static String ALIAS = " AS ZZ";


    public static String[] tokenizer(String exp2) {
        //  System.out.println(exp2);

        // initializing empty String for result
        String exp = exp2.trim().replaceAll(Operator.GT_EQ.getValue(), Operator.GT_EQ.getEncodedValue())
                .replaceAll(Operator.ST_EQ.getValue(), Operator.ST_EQ.getEncodedValue())
                .replaceAll(Operator.GT.getValue(), Operator.GT.getEncodedValue())
                .replaceAll(Operator.ST.getValue(), Operator.ST.getEncodedValue())
                .replaceAll(Operator.NOT_EQ.getValue(), Operator.NOT_EQ.getEncodedValue())
                .replaceAll(Operator.EQ.getValue(), Operator.EQ.getEncodedValue())
                .replaceAll(Operator.NOT.getValue(), Operator.NOT.getEncodedValue());
        String delims;
        delims = "(?=\\()|(?<=\\()|(?=\\))|(?<=\\))|(?=\\s)|(?<=\\s)|(?=,)|(?<=,)";
        delims += "|(?=" + Operator.GT.getEncodedValue() + ")|(?<=" + Operator.GT.getEncodedValue() + ")";
        delims += "|(?=" + Operator.GT_EQ.getEncodedValue() + ")|(?<=" + Operator.GT_EQ.getEncodedValue() + ")";
        delims += "|(?=" + Operator.ST.getEncodedValue() + ")|(?<=" + Operator.ST.getEncodedValue() + ")";
        delims += "|(?=" + Operator.ST_EQ.getEncodedValue() + ")|(?<=" + Operator.ST_EQ.getEncodedValue() + ")";
        delims += "|(?=" + Operator.NOT_EQ.getEncodedValue() + ")|(?<=" + Operator.NOT_EQ.getEncodedValue() + ")";
        delims += "|(?=" + Operator.EQ.getEncodedValue() + ")|(?<=" + Operator.EQ.getEncodedValue() + ")";
        delims += "|(?=" + Operator.NOT.getEncodedValue() + ")|(?<=" + Operator.NOT.getEncodedValue() + ")";

        String[] tokens = exp.split(delims);
        return tokens;
    }

    public static boolean transformValueAndCheckIfSpecial(String[] tokens, JsonObject userAttributes) {
        Map<String, Operator> encodedOperatorMap = getEncodedValueMap();
        boolean isSpecial = false;
        boolean isNull = false;
        boolean paran = false;
        boolean orParam = false;
        int k=0;
        for (int i = 0; i < tokens.length; i++) {        	
            if (tokens[i].startsWith($)) {
            	isNull = false ;
                tokens[i] = replaceUserAttributeWithValue(tokens, i, userAttributes);
                //TODO: logic for jwt attribute for null or empty is not implemented yet
                if(tokens[i] == null){
                	isNull = true;
                	paran = false ;
                	orParam = false;
                	tokens[i]=" ";
                	k=i;
                	if (i<tokens.length - 1 && isSpecial == false){
                		while (!(tokens[i].equals(AND) || tokens[i].equals(OR))){
                			if (!(tokens[i].contains(LEFT_PARANTHESIS) || tokens[i].contains(RIGHT_PARANTHESIS)))
                			tokens[i]=" ";
                			i++;
                			if (i > tokens.length - 1)
                				return isSpecial;               		
                		}
                		if (tokens[i].equals(AND) || tokens[i].equals(OR))
                		{                			
                			tokens[i]=" ";
                		}
                	}
                	else{
                		if (isSpecial == true ) {
                			while (!(tokens[k].equals(AND) || tokens[k].equals(OR)) && k != tokens.length - 1 && !(tokens[k].contains(LEFT_PARANTHESIS) || tokens[k].contains(RIGHT_PARANTHESIS))){
                				k=k+1;
                			}
                			if ((tokens[k].contains(LEFT_PARANTHESIS) || tokens[k].contains(RIGHT_PARANTHESIS))){
                				paran = true;
                			}
                			if (!(tokens[k].contains(LEFT_PARANTHESIS) || tokens[k].contains(RIGHT_PARANTHESIS) || tokens[k].contains(OR)))
                			tokens[k]=" "; 
                		}
                		i=k;
                		if (tokens[i].equals(OR)){  
                			orParam = true;
                			while(!(tokens[i].contains(LEFT_PARANTHESIS) || tokens[i].contains(RIGHT_PARANTHESIS))){
                				tokens[i]=" "; 
                				i++;
                				if (i > tokens.length - 1)
                				break;
                			}                			
                		i=k;
                		}
                		while (i >= 0  && !(tokens[i].equals(AND) || tokens[i].equals(OR)))                		
                		{
                			if (!(tokens[i].contains(LEFT_PARANTHESIS) || tokens[i].contains(RIGHT_PARANTHESIS)))
                			tokens[i]=" ";                			
                			if (i == 0)
                				break;
                			i--;
                		}
                
                		if ((k == tokens.length -1 && ( tokens[i].equals(AND) || tokens[i].equals(OR))) || paran == true || (orParam == true && (!(tokens[i].contains(LEFT_PARANTHESIS) || tokens[i].contains(RIGHT_PARANTHESIS)))))
                		{
                			tokens[i]=" ";
                		}
                		// tokens[i] = ExpressionExecutorUtil.SKIP_VALUE;
                		if (k == tokens.length -1)
                			return isSpecial;
                		else i = k+1;
                	}
                }
              
                if (!(isNumeric(tokens[i])) && isNull == false  
                        && !tokens[i].startsWith(Operator.IN.getValue())
                        && !tokens[i].startsWith(Operator.IS.getValue())) {
                    // add single quotes for non numeric values
                    tokens[i] = "'" + tokens[i] + "'";
                }

            } else if (encodedOperatorMap.get(tokens[i]) != null) {
                tokens[i] = encodedOperatorMap.get(tokens[i]).getValue();
            }

            if (!isSpecial) {
                isSpecial = isContinsAlpha(tokens[i]);
            }
        }


        return isSpecial;

    }


    private static String replaceUserAttributeWithValue(String[] tokens, int index, JsonObject userAttributes) {
        String curOperand = tokens[index];
        if (curOperand.startsWith($)) {
            String updatedOperand = curOperand.substring(ONE);
            String[] atttibuteKeys = updatedOperand.split("\\.", 2);
            int size = atttibuteKeys.length - 1;
            String attributeKey = atttibuteKeys[size];
            JsonElement value = userAttributes.get(attributeKey);

            //attribute not present in user attributes
            if (value == null) {
                value = JWTUtil.getValueForAnyAttributeFromJWT(attributeKey);
            }
            if (null != value) {
                if (value.isJsonArray()) {
                    JsonArray values = value.getAsJsonArray();
                    if (values.size() == 1) {
                        curOperand = value.getAsJsonArray().get(0).getAsString(); // always takes first index
                    } else if (values.size() >= 2) {
                        //if multivalue found then we need to replace with IN('a','b',1,2)
                        // and remove previous = operator
                        int temp = index;
                        while (!Operator.EQ.getValue().equals(tokens[temp])) {
                            temp--;
                        }
                        // replace = operator with empty space
                        tokens[temp] = " ";
                        // remove duplicate values
                        Set<String> valuesSet = new HashSet<>();
                        for (int i = 0; i < values.size(); i++) {
                            valuesSet.add(values.get(i).getAsString());
                        }
                        Iterator<String> itr = valuesSet.iterator();
                        StringBuilder sb = new StringBuilder(Operator.IN.getValue());
                        sb.append(LEFT_PARANTHESIS);
                        int count = 1;
                        int valSize = valuesSet.size();
                        while (itr.hasNext()) {
                            String attrVal = itr.next();
                            if (isNumeric(attrVal)) {
                                if (count != valSize)
                                    sb.append(attrVal + COMMA);
                                else
                                    sb.append(attrVal);
                            } else {
                                if (count != valSize)
                                    sb.append("'" + attrVal + "'" + COMMA);
                                else
                                    sb.append("'" + attrVal + "'");

                            }
                            count++;
                        }
                        sb.append(RIGHT_PARANTHESIS);
                        curOperand = sb.toString();
                    } else {
                        //  empty value
                        curOperand = null;
                    }

                } else {
                    curOperand = value.getAsString();
                }
            } else {
                curOperand = null;
            }
        }
        return curOperand;
    }


    public static StringBuilder convertToPseudoSql(String[] tokens) {
        StringBuilder sb = new StringBuilder("");
        if (tokens.length == 0) {
            return sb;
        }
        sb.append("(");
        for (int i = 0; i < tokens.length - 1; i++) {
        	if (!tokens[i].equals(" "))
            sb.append(tokens[i] + " ");
        }
        sb.append(tokens[tokens.length - 1]);
        sb.append(")");
        if (sb.substring(sb.indexOf("(")+1, sb.lastIndexOf(")")).equals(" ") || sb.substring(sb.indexOf("(")+1, sb.lastIndexOf(")")).matches("[( )]+"))
        return null;
        else 
        return sb;
    }

    public static Queue<Object> infixToPostfix(String exp) {

        String[] tokens = tokenizer(exp);
        //TODO: optimise the map creation later on
        Map<String, Operator> encodedOpMap = getEncodedValueMap();
        Map<String, Operator> valueOpMap = getValueMap();

        Queue<Object> resultSt = new LinkedList<>();
        Stack<Object> expSt = new Stack<>();
        String token = null;

        for (int index = 0; index < tokens.length; index++) {
            token = tokens[index];
            if (LEFT_PARANTHESIS.equals(token)) {
                expSt.push(LEFT_PARANTHESIS);
            } else if (RIGHT_PARANTHESIS.equals(token)) {
                while (!expSt.isEmpty() && !(expSt.peek() instanceof String && LEFT_PARANTHESIS.equals(expSt.peek())))
                    resultSt.add(expSt.pop());
                // pop LEFT_PARANTHESIS
                expSt.pop();
            } else if (token.startsWith("#") && encodedOpMap.get(token.toUpperCase()) != null) {

                processOperator(encodedOpMap.get(token.toUpperCase()), resultSt, expSt);
            }
            /*operand value so add it as an operand
            tokens wil look like below for value having space example  '3M 4A Printing Paper'
             token[0]="'3M"
             token[1]= "4A"
             token[2]= "Printing"
             token[3]= "Paper'"
             so we neeed to combine it as a single operand value
             for single valued value without any space it will like 'PrintingPaper'
             token[0] = 'PrintingPaper'
             */
            else if (token.startsWith("'") && !token.endsWith("'")) {

                StringBuilder tempSb = new StringBuilder(token);
                int temp = index;
                temp++;
                while (!tokens[temp].endsWith("'")) {
                    tempSb.append(tokens[temp]);
                    temp++;
                }
                tempSb.append(tokens[temp]);
                index = temp;
                resultSt.add(new Operand(tempSb.toString()));
            } else if (valueOpMap.get(token.toUpperCase()) != null) {
                Operator opr = valueOpMap.get(token.toUpperCase());
                /*
                    If IN Operator found then push rest of values inside () and skip index to next token
                 */
                if (opr == Operator.IN) {
                    int temp = index;
                    while (!LEFT_PARANTHESIS.equals(tokens[temp])) {
                        temp++;
                    }
                    StringBuilder tempSb = new StringBuilder("");
                    while (!RIGHT_PARANTHESIS.equals(tokens[temp])) {
                        tempSb.append(tokens[temp]);
                        temp++;
                    }
                    tempSb.append(tokens[temp]);
                    index = temp;
                    resultSt.add(new Operand(tempSb.toString()));
                }
                processOperator(valueOpMap.get(token.toUpperCase()), resultSt, expSt);

            } else if (!SPACE.equals(token)) {
                resultSt.add(new Operand(token));
            }

        }

        // pop all the operators from the stack
        while (!expSt.isEmpty()) {
            resultSt.add(expSt.pop());
        }


        return resultSt;
    }

    public static InfixSQL convertPostfixToInfix(Queue postFixQueue, Map<CaseInsensitiveString, String> propertyTypeMap, 
        boolean isHanaSql, String serviceName, String entityName) {

        if (postFixQueue.isEmpty()) {
            return null;
        }
        Deque<InfixParam> infixParams = new LinkedList<>();
        Operand operand1, operand2;
        Object token;
        Operator opr;
        String dataType = null;
        String fqSubSelectTable = null;
        String subSelectTable = null;
        
        // Helps in retrieving original property name
        Map<String, CaseInsensitiveString> propertyNames = new HashMap<>();
        for (CaseInsensitiveString key : propertyTypeMap.keySet()) {
            propertyNames.put(key.getValue().toLowerCase(), key);
        }

        Stack<Operand> stack = new Stack<>();
        while (!postFixQueue.isEmpty()) {
            token = postFixQueue.remove();
            if (token instanceof Operand) {
                fqSubSelectTable = getSubSelectTable(serviceName, token, fqSubSelectTable, stack);
                stack.push((Operand) token);
            } else {
                operand1 = stack.pop();
                operand2 = stack.pop();
                Operand temp = operand1;
                // swap operand if operand1 is not actual column name
                if (propertyTypeMap.get(new CaseInsensitiveString(operand1.getValue())) == null) {
                    operand1 = operand2;
                    operand2 = temp;

                }
                CaseInsensitiveString currentColoumnName = null;
                String currentColoumnPropertyName = null;
                subSelectTable = fqSubSelectTable != null ? fqSubSelectTable.split("[\\._]")[1] : null;
                opr = (Operator) token;
                boolean isNamespaceQualified = false;
                // optimisation to stop searching for valid coloumnName
                if (!operand1.getValue().startsWith(LEFT_PARANTHESIS)) {
                  String values[] = operand1.getValue().split("\\.");
                  currentColoumnName = new CaseInsensitiveString(values[values.length - 1]);
                  // Check if column is part of the sub select table
                  if ((fqSubSelectTable != null) && (operand1.getValue().contains(subSelectTable) || CSNUtil.getAllColumns(serviceName, subSelectTable)
                      .contains(currentColoumnName.getValue()))) {
                    dataType = getColumnDataTypeFromCSN(serviceName, subSelectTable, currentColoumnName);
                    currentColoumnPropertyName = fqSubSelectTable + "." + currentColoumnName.getValue().toLowerCase();
                    isNamespaceQualified = true;
                  } // Check if column is part of the outer entity 
                  else if (operand1.getValue().contains(entityName) || propertyNames.get(currentColoumnName.getValue().toLowerCase()) != null) {
                    dataType = propertyTypeMap.get(currentColoumnName);
                    currentColoumnPropertyName = getColumnNameFromOuterEntity(serviceName, entityName, dataType,
							propertyNames, currentColoumnName, currentColoumnPropertyName);
                    isNamespaceQualified = true;
                  }
                  if (isHanaSql) {
                      // hana sql is casesensitive so we need to pass the correct property name case
                      operand1 = isNamespaceQualified ? new Operand(currentColoumnPropertyName).getOperandWithoutAlisCDS(isPlainSqlMapping()) :
                    	  new Operand(currentColoumnPropertyName).getOperandWithPrefixedAlias(ALIAS_Prefix, isPlainSqlMapping());

                  } else {
                	  operand1 = isNamespaceQualified ? new Operand(currentColoumnPropertyName).getOperandWithoutAlisCDS(isPlainSqlMapping()) : 
                		  operand1.getOperandWithPrefixedAliasCDS(ALIAS_Prefix,isPlainSqlMapping());
                  }
                }
                // null check
                if (dataType != null) {

                    // optimisation for only transformation of valid operand
                    if (!operand2.getValue().startsWith(LEFT_PARANTHESIS)) {
                      isNamespaceQualified = false;
                      String tempVal = null;
                      String values[] = operand2.getValue().split("\\.");
                      currentColoumnName = new CaseInsensitiveString(values[values.length - 1]);                  
                      // Check if column is part of the outer entity
                      if (operand2.getValue().equalsIgnoreCase(entityName) || propertyNames.get(currentColoumnName.getValue().toLowerCase()) != null) {
                    	  dataType = propertyTypeMap.get(currentColoumnName);
                    	  tempVal = getColumnNameFromOuterEntity(serviceName, entityName, dataType, propertyNames,
								currentColoumnName, tempVal);                   
                        isNamespaceQualified = true;
                      } // Check if column is part of the sub select entity
                      else if ((fqSubSelectTable != null) && operand2.getValue().equalsIgnoreCase(subSelectTable) || CSNUtil.getAllColumns(serviceName, subSelectTable)
                          .contains(currentColoumnName.getValue())) {              
                        dataType = getColumnDataTypeFromCSN(serviceName, subSelectTable, currentColoumnName);
                        tempVal = fqSubSelectTable + "." + currentColoumnName.getValue().toLowerCase();
                        isNamespaceQualified = true;
                      } else {
                        tempVal = operand2.getValue(); 
                      }
                        //don't do any hana specific where condition clause has is null
                        if (isHanaSql && !NULL.equals(tempVal)) {
                            if (tempVal.startsWith("'") && tempVal.endsWith("'")) {
                                tempVal = tempVal.substring(1, tempVal.length() - 1);
                            }                            
                        	operand2 = isNamespaceQualified ? new Operand(tempVal).getOperandWithoutAlisCDS(isPlainSqlMapping()) :
                        		new Operand(HANA_PARAM_PLACEHOLDER);
                        	if (!isNamespaceQualified) {
                        		infixParams.add(new InfixParam(currentColoumnPropertyName, tempVal, dataType, fqSubSelectTable));
                        	}
                        } else {
                    		// handles non hana sql and is null condition
                        	operand2 = isNamespaceQualified ? new Operand(tempVal).getOperandWithoutAlisCDS(isPlainSqlMapping()) :  
                        			new Operand(getTransformedRightOperand(dataType, tempVal));
                        }
                    }
                    // special handling for right side IN operandvalue (abc,bcd) or if ('abc','bcd')
                    else if (opr == Operator.IN) {
                    	StringBuilder inClauseBuilder = new StringBuilder();
                        String inClauseTokens[] = tokenizer(operand2.getValue());
                        for (int index = 0; index < inClauseTokens.length; index++) {
                            String tempToken = inClauseTokens[index];
                            if(((tempToken.charAt(0) == 39 && tempToken.charAt(tempToken.length() - 1) != 39)) || tempToken.equals("'"))
                            {
                            	StringBuilder sb2 = new StringBuilder();
                            	while(inClauseTokens[index].charAt(inClauseTokens[index].length() - 1) != 39 || inClauseTokens[index].equals("'")){
                            		sb2.append(inClauseTokens[index]);
                            		index++;                          			

                            	}
                            	sb2.append(inClauseTokens[index]);
                            	tempToken= sb2.toString();	
                            }
                            if (!(LEFT_PARANTHESIS.equals(tempToken) || COMMA.equals(tempToken) || RIGHT_PARANTHESIS.equals(tempToken))) {

                                if (isHanaSql) {
                                    //remove single quotes if present for hana sql
                                    if ((tempToken.charAt(0) == 39 && tempToken.charAt(tempToken.length() - 1) == 39)) {
                                        tempToken = tempToken.substring(1, tempToken.length() - 1);
                                    }
                                    infixParams.add(new InfixParam(currentColoumnPropertyName, tempToken, dataType, fqSubSelectTable));
                                    tempToken = HANA_PARAM_PLACEHOLDER;
                                } else {
                                    tempToken = getTransformedRightOperand(dataType, tempToken);
                                }
                            }
                            inClauseBuilder.append(tempToken);
                        }
                        // combine tokens
                     //   StringBuilder sbINClause = new StringBuilder("");
                      /*  for (int index = 0; index < inClauseTokens.length; index++) {
                            sbINClause.append(inClauseTokens[index]);
                        }*/
                        operand2 = new Operand(inClauseBuilder.toString());

                    }
                }

                stack.push(operand1.transformToInfixOperand(opr, operand2));
            }
        }
        
        Operand result = null;
        StringBuilder str = new StringBuilder();
        if (fqSubSelectTable != null) {
        	str = generateSubSelectQuery(isHanaSql, fqSubSelectTable, stack, str);
        } else {
        	result = stack.pop();
        }
        if (isHanaSql) {
            return fqSubSelectTable != null ? new InfixSQL(str.toString(), infixParams) : new InfixSQL(result.getValue(), infixParams);
        }
        return fqSubSelectTable != null ? new InfixSQL(str.toString()) : new InfixSQL(result.getValue());

    }

	private static StringBuilder generateSubSelectQuery(boolean isHanaSql, String fqSubSelectTable, Stack<Operand> stack,
			StringBuilder str) {
		String operator = stack.elementAt(0).getValue();
		if (operator.equalsIgnoreCase(NOT)) {
			operator += SPACE + stack.elementAt(1).getValue();
		}
		String whereList = null;
		String columnList = "";
		while (!stack.empty() && !stack.peek().getValue().equalsIgnoreCase(WHERE.trim())) {
			whereList = stack.pop().getValue();
		}
		while(!stack.empty() && !stack.peek().getValue().equals(FROM.trim())) {
			stack.pop();
		}
		stack.pop();
		while(!stack.empty() && !stack.peek().getValue().equals(SELECT.trim())) {
			String value = stack.pop().getValue();
			columnList += !value.equalsIgnoreCase(",") ? getPersistenceName(fqSubSelectTable, value) : value;
		}
		if (!isHanaSql) {
			str.append(operator);
			str.append(LEFT_PARANTHESIS + SELECT + FROM).append(convertToUpperCaseIfRequired(fqSubSelectTable));
			str.append(LEFT_CURLY_PARANTHESIS).append(columnList).append(RIGHT_CURLY_PARANTHESIS);
			str.append(WHERE).append(SPACE).append(whereList).append(SPACE + RIGHT_PARANTHESIS);
		} else {
			str.append(operator);
			str.append(LEFT_PARANTHESIS + SELECT).append(columnList).append(FROM)
			.append(fqSubSelectTable).append(WHERE).append(whereList).append(SPACE + RIGHT_PARANTHESIS);
		}
		return str;
	}

	private static String getPersistenceName(String fqEntityName, String elementName) {
		String persistenceName = null;
		boolean isHdbcdsMode = CSNUtil.isHdbcdsMapping();
		if (isHdbcdsMode) {
			persistenceName = CSNUtil.getPersistenceName(fqEntityName, elementName);
		}
		if (persistenceName == null) {
			if (elementName != null) {
				persistenceName = convertToUpperCaseIfRequired(elementName);
			}
		}
		return persistenceName + ALIAS + persistenceName;
	}

	private static String getColumnNameFromOuterEntity(String serviceName, String entityName, String dataType,
			Map<String, CaseInsensitiveString> propertyNames, CaseInsensitiveString currentColoumnName,
			String tempVal) {
		if (dataType != null) {
			  tempVal = propertyNames.get(currentColoumnName.getValue().toLowerCase()).getValue();
			  tempVal = quoteIfRequired(ALIAS_Prefix + tempVal); 
		  }
		return tempVal;
	}

	private static String getColumnDataTypeFromCSN(String serviceName, String subSelectTable,
			CaseInsensitiveString currentColoumnName) {
		String dataType;
		String cdsDataType = CSNUtil.getCDSDataType(subSelectTable, serviceName, currentColoumnName.getValue());
		dataType = cdsDataType != null ? cdsDataType.substring(cdsDataType.indexOf(".") + 1) : null;
		return dataType;
	}

	private static String getSubSelectTable(String serviceName, Object token, String subSelectTable,
			Stack<Operand> stack) {
		if (((Operand) token).getValue().equalsIgnoreCase("where")) {
		  subSelectTable = stack.peek().getValue();
		  String tableNames[] = subSelectTable.split("\\.");                  
		  subSelectTable = tableNames.length > 1 ? quoteIfRequired(replaceDotIfRequired(subSelectTable)) :
			  quoteIfRequired(replaceDotIfRequired(serviceName + "." + subSelectTable));
		}
		return subSelectTable;
	}

    private static String getTransformedRightOperand(String dataType, String rightVal) {
        StringBuilder rightExp = new StringBuilder();
        if (dataType == null) {
            return null;
        }
        // used for is null where condition
        if (NULL.equalsIgnoreCase(rightVal)) {
            return NULL;
        }
        switch (dataType) {
            case "Edm.Guid":
                // same logic for guid
            case "Edm.String":
                // used for empty string condition
                if ("\"\"".equals(rightVal)) {
                    rightExp.append("''");

                }
                //ASCII value of ' is 39 if already single quote  wrapped around ignore else add
                else if (!(rightVal.charAt(0) == 39 && rightVal.charAt(rightVal.length() - 1) == 39)) {
                    rightExp.append("'");
                    rightExp.append(rightVal);
                    rightExp.append("'");
                } else {
                    // no changes required return as it is
                    return rightVal;
                }
                break;
            default:
                // no changes done return as it is
                return rightVal;
        }
        return rightExp.toString();
    }

    private static void processOperator(Operator op, Queue<Object> resultStack, Stack<Object> expStack) {

        while (!expStack.isEmpty() && (op.precedence <= Prec(expStack.peek()))) {

            resultStack.add(expStack.pop());
        }
        expStack.push(op);

    }

    static int Prec(Object token) {
        if (token instanceof Operator) {
            return ((Operator) token).getPrecedence();
        }
        return -1;
    }

    private static boolean isNumeric(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");
    }

    /**
     * Checks if atleast one alphapet is present or not
     *
     * @param s
     * @return
     */
    private static boolean isContinsAlpha(String s) {
        return s != null && s.matches(".*[a-zA-Z]+.*");
    }

}

