/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpServletRequest;

@WebListener
public class AuthorizationListener implements ServletRequestListener {

	private static final Logger log = LoggerFactory.getLogger(AuthorizationListener.class);

	@Override
	public void requestDestroyed(ServletRequestEvent sre) {
		log.debug("Destroying Authorization as it is end of request.");
		AuthorizationService.purgeCurrentAuthorization();
	}

	@Override
	public void requestInitialized(ServletRequestEvent sre) {
		/*
		 	Note:The jwt token is set here
		*/
			log.debug("Reading user principal"); 
			// if container switch is ON these all should happen
			HttpServletRequest req = (HttpServletRequest) sre.getServletRequest();
			String jwtTokenAsStr = req.getHeader("authorization");
			if(null != jwtTokenAsStr) {
				jwtTokenAsStr = jwtTokenAsStr.replace("Bearer ", "");
				AuthorizationService.setJWTToken(jwtTokenAsStr);
			}
	}
}
