/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.security;

/**
 * This is to support existing CDS definitions without authorization information.
 * If no authorization information is found, it passes authorization check. 
 * 
 *
 */
public class BackwardCompatibility extends AuthorizationDecorator {
	
	private Authorization authorization;

	public BackwardCompatibility(Authorization authorization) {
		super(authorization);
		this.authorization = authorization;
	}
	
	/* (non-Javadoc)
	 * @see com.sap.cloud.sdk.service.prov.api.security.AuthorizationDecorator#isAuthenticatedUser(java.lang.String)
	 */
	@Override
	public boolean isAuthenticatedUser(String serviceName) {
		if(AuthorizationRulesContainer.isRuleExist(serviceName)) {
			return authorization.isAuthenticatedUser(serviceName);
		}
		return true;
	}
	
	/* (non-Javadoc)
	 * @see com.sap.cloud.sdk.service.prov.api.security.AuthorizationDecorator#isRegisteredUser(java.lang.String)
	 */
	@Override
	public boolean isRegisteredUser(String serviceName) {
		if(AuthorizationRulesContainer.isRuleExist(serviceName)) {
			return authorization.isRegisteredUser(serviceName);
		}
		return true;
	}
	
	/* (non-Javadoc)
	 * @see com.sap.cloud.sdk.service.prov.api.security.AuthorizationDecorator#hasAuthorization(java.lang.String, java.lang.String)
	 */
	@Override
	public boolean hasEntityAccess(String entityName, String operation) {
		if(AuthorizationRulesContainer.isRuleExist(entityName)) {
			return authorization.hasEntityAccess(entityName, operation);
		}
		return true;
	}
}
