/*******************************************************************************
 * (c) 201X SAP SE or an SAP affiliate company. All rights reserved.
 ******************************************************************************/
package com.sap.cloud.sdk.service.prov.api.security;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Container based security.
 */
public class ContainerSecurityImpl extends Authorization {

    private static final Logger log = LoggerFactory.getLogger(ContainerSecurityImpl.class);



    public ContainerSecurityImpl() {  // default implementation ignored
    }

    /*
     * (non-Javadoc)
     *
     * @see
     * com.sap.cloud.sdk.service.prov.api.security.Authorization#isAuthenticatedUser
     * (java.lang.String)
     */
    @Override
    public boolean isAuthenticatedUser(String serviceName) {
        AuthorizationDetails authDetails = AuthorizationRulesContainer.getRule(serviceName);
        if (authDetails == null) {
            log.debug("No authorization details found for the Service: {} ", serviceName);
            return false;
        }
        return SecurityUtil.isAuthenticatedUser(authDetails,serviceName);
    }

    /*
     * (non-Javadoc)
     *
     * @see
     * com.sap.cloud.sdk.service.prov.api.security.Authorization#isRegisteredUser(
     * java.lang.String)
     */
    @Override
    public boolean isRegisteredUser(String serviceName) {
        return isAuthenticatedUser(serviceName);
    }

    /*
     * (non-Javadoc)
     *
     * @see
     * com.sap.cloud.sdk.service.prov.api.security.Authorization#hasEntityAccess(
     * java.lang.String, java.lang.String)
     */
    @Override
    public boolean hasEntityAccess(String entityName, String operation) {
        log.debug("Authorization Check for Service: {} and Operation: {}", entityName, operation);
        return SecurityUtil.hasEntityAccess(entityName,operation);
    }

    /*
     * (non-Javadoc)
     *
     * @see com.sap.cloud.sdk.service.prov.api.security.Authorization#getUserName()
     */
    @Override
    public String getUserName() {
        return  SecurityUtil.getUserName();
    }

    /*
     * (non-Javadoc)
     *
     * @see com.sap.cloud.sdk.service.prov.api.security.Authorization#getUserId()
     */
    @Override
    public String getUserId() {
        return SecurityUtil.getUserId();
    }

    @Override
    public boolean hasUserRole(String roleName) {
        return SecurityUtil.hasUserRole(roleName);
    }

    /*
     * (non-Javadoc)
     *
     * @see
     * com.sap.cloud.sdk.service.prov.api.security.Authorization#getUserAttribute(
     * java.lang.String)
     */
    @Override
    public String getUserAttribute(String attributeName) {
        return JWTUtil.getJWTAttribute(attributeName);
    }
}
